/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinPlugin;
import cds.aladin.Box;
import cds.aladin.Calib;
import cds.aladin.Calque;
import cds.aladin.Cercle;
import cds.aladin.Constellation;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.CoteDist;
import cds.aladin.CropTool;
import cds.aladin.CubeControl;
import cds.aladin.Ellipse;
import cds.aladin.FrameProp;
import cds.aladin.FrameVOTool;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.Localisation;
import cds.aladin.Message;
import cds.aladin.MyScrollbar;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanField;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlink;
import cds.aladin.PlanImageHuge;
import cds.aladin.PlanImageMosaic;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Rainbow;
import cds.aladin.RainbowPixel;
import cds.aladin.Repere;
import cds.aladin.RepereSimbad;
import cds.aladin.RepereSpectrum;
import cds.aladin.Save;
import cds.aladin.Select;
import cds.aladin.Server;
import cds.aladin.Source;
import cds.aladin.SourceStat;
import cds.aladin.SourceTag;
import cds.aladin.Status;
import cds.aladin.Synchro;
import cds.aladin.Tag;
import cds.aladin.Tok;
import cds.aladin.ViewControl;
import cds.aladin.ViewMemo;
import cds.aladin.ViewSimple;
import cds.aladin.ViewSimpleStatic;
import cds.aladin.ZoomView;
import cds.aladin.prop.Propable;
import cds.tools.UrlLoader;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.ColorModel;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class View
extends JPanel
implements Runnable,
AdjustmentListener {
    static final String WNOZOOM = "You have reached the zoom limit";
    static final int CMSIZE = 150;
    Font F = Aladin.SPLAIN;
    protected static int INITW = 512;
    protected static int INITH = 512;
    protected Color gridColor;
    protected Color gridColorRA;
    protected Color gridColorDEC;
    protected int gridFontSize;
    protected Color infoColor;
    protected Color infoLabelColor;
    protected boolean infoBorder;
    protected int infoFontSize;
    Aladin aladin;
    Calque calque;
    ZoomView zoomview;
    Status status;
    static final int LEVEL = 0;
    static final int REAL = 1;
    static final int INFILE = 2;
    static final int REALX = 3;
    Vector<Obj> vselobj = new Vector(500);
    String saisie = "";
    boolean nextSaisie = true;
    protected Repere repere;
    protected CropTool crop;
    protected Constellation constellation;
    boolean first = true;
    boolean _flagTimer = false;
    boolean _flagSesameResolve = false;
    protected int blinkMode = 0;
    protected Obj newobj;
    protected JPanel mviewPanel;
    protected ViewMemo viewMemo;
    protected ViewMemo viewSticked;
    private boolean[] memoStick;
    protected int mouseView = -1;
    protected ViewSimple[] viewSimple;
    protected int currentView;
    protected int modeView = 1;
    protected MyScrollbar scrollV;
    private int previousScrollGetValue = 0;
    private Point memoPos = null;
    protected boolean selectFromView = false;
    private ViewSimple megaDragViewSource = null;
    private Plan megaDragPlanSource = null;
    private ViewSimple megaDragViewTarget = null;
    protected boolean flagMegaDrag = false;
    protected boolean flagHighlight = false;
    protected static String NOZOOM;
    protected static String MSTICKON;
    protected static String MSTICKOFF;
    protected static String MOREVIEWS;
    protected static String MLABELON;
    protected static String MCOPY;
    protected static String MTARGETHISTORY;
    protected static String MCOPYIMG;
    protected static String MLOOK;
    protected static String MLABELOFF;
    protected static String MNEWROI;
    protected static String MPLOT;
    protected static String MDELROI;
    protected static String MSEL;
    protected static String MDELV;
    protected static String VIEW;
    protected static String ROIWNG;
    protected static String ROIINFO;
    protected static String HCLIC;
    protected static String HCLIC1;
    protected static String NIF;
    protected static String NEXT;
    private ViewSimple lastClickView = null;
    private static final String CASSISDEMAND = "CASSISDEMAND";
    static final int STR = 0;
    static final int EGAL = 1;
    static final int DIFF = 2;
    static final int SUP = 3;
    static final int INF = 4;
    static final int SUPEG = 5;
    static final int INFEG = 6;
    static final int EGALL = -1;
    private String[] OP = new String[]{"", "=", "!=", ">", "<", ">=", "<="};
    private long lastRepaint = 0L;
    private HashMap<String, String> miniCache = new HashMap();
    static Coord oco;
    static String oobjet;
    private Source lastShowSource = null;
    private int defaultDelais = 1000;
    volatile Thread timer = null;
    protected Synchro sesameSynchro = new Synchro(10000L);
    boolean first1 = true;
    private int nbSesameCheck = 0;
    private static final int MAXSESAMECHECK = 2;
    protected CoteDist coteDist = null;
    protected RepereSimbad simRep = null;
    private Timer timerQuickSimbad = null;
    private boolean isQuickSimbad = false;
    private boolean isQuickVizieR = false;
    protected float opaciteFoV = 1.0f;
    boolean activeFoV = true;
    protected float opaciteGrid = 1.0f;

    protected void createChaine() {
        NOZOOM = Aladin.chaine.getString("VWNOZOOM");
        MSTICKON = Aladin.chaine.getString("VWMSTICKON");
        MSTICKOFF = Aladin.chaine.getString("VWMSTICKOFF");
        MCOPYIMG = Aladin.chaine.getString("VWMCOPYIMG");
        MLOOK = Aladin.chaine.getString("VWMLOOK");
        MCOPY = Aladin.chaine.getString("VWMCOPY");
        MTARGETHISTORY = Aladin.chaine.getString("VWMTARGETHISTORY");
        MLABELON = Aladin.chaine.getString("VWMLABELON");
        MLABELOFF = Aladin.chaine.getString("VWMLABELOFF");
        MOREVIEWS = Aladin.chaine.getString("VWMOREVIEWS");
        NEXT = Aladin.chaine.getString("VWNEXT");
        MNEWROI = Aladin.chaine.getString("VWMNEWROI");
        MPLOT = Aladin.chaine.getString("VWMPLOT");
        MDELROI = Aladin.chaine.getString("VWMDELROI");
        MSEL = Aladin.chaine.getString("VWMSEL");
        MDELV = Aladin.chaine.getString("VWMDELV");
        VIEW = Aladin.chaine.getString("VWVIEW");
        ROIWNG = Aladin.chaine.getString("VWROIWNG");
        ROIINFO = Aladin.chaine.getString("VWROIINFO");
        HCLIC = Aladin.chaine.getString("VWHCLIC");
        HCLIC1 = Aladin.chaine.getString("VWHCLIC1");
        NIF = Aladin.chaine.getString("VWNIF");
    }

    protected View(Aladin aladin) {
        this.aladin = aladin;
        aladin.view = this;
    }

    protected View(Aladin aladin, Calque calque) {
        this.aladin = aladin;
        this.createChaine();
        this.status = aladin.status;
        this.calque = calque;
        this.zoomview = aladin.calque.zoom.zoomView;
        int nitem = aladin.viewControl.getNbCol(1);
        this.scrollV = new MyScrollbar(1, 0, nitem, 0, 16 / nitem);
        this.scrollV.setUnitIncrement(nitem);
        this.scrollV.setBlockIncrement(nitem);
        this.scrollV.addAdjustmentListener(this);
        this.mviewPanel = new JPanel();
        this.mviewPanel.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", this.mviewPanel);
        this.createRepere();
        this.viewMemo = new ViewMemo();
        this.viewSticked = new ViewMemo();
        this.viewSimple = new ViewSimple[16];
        this.memoStick = new boolean[16];
        int w = INITW / aladin.viewControl.getNbCol(this.modeView);
        int h = INITH / aladin.viewControl.getNbLig(this.modeView);
        for (int i = 0; i < 16; ++i) {
            this.viewSimple[i] = new ViewSimple(aladin, this, w, h, i);
            this.viewMemo.set(i, this.viewSimple[i]);
            this.viewSticked.set(i, (ViewSimple)null);
        }
        this.adjustPanel(this.modeView);
        this.setCurrentNumView(0);
        this.setBackground(Color.white);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.next(1);
            }
        }, KeyStroke.getKeyStroke(9, 1), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.next(-1);
            }
        }, KeyStroke.getKeyStroke(9, 0), 2);
        this.initGridParam(false);
        this.initInfoParam(false);
    }

    protected void initGridParam(boolean repaint) {
        this.gridColor = this.aladin.configuration.getGridColor();
        this.gridColorRA = this.aladin.configuration.getGridColorRA();
        this.gridColorDEC = this.aladin.configuration.getGridColorDE();
        this.gridFontSize = this.aladin.configuration.getGridFontSize();
        if (repaint) {
            this.repaintAll();
        }
    }

    protected void initInfoParam(boolean repaint) {
        this.infoColor = this.aladin.configuration.getInfoColor();
        this.infoLabelColor = this.aladin.configuration.getInfoLabelColor();
        this.infoBorder = this.aladin.configuration.isInfoBorder();
        this.infoFontSize = this.aladin.configuration.getInfoFontSize();
        if (repaint) {
            this.repaintAll();
        }
    }

    protected void setSelectFromView(boolean flag) {
        this.selectFromView = flag;
        if (flag) {
            this.aladin.calque.select.showSelectedPlan();
        }
    }

    protected boolean isViewSelected() {
        if (!this.selectFromView) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (!this.viewSimple[i].selected) continue;
            return true;
        }
        return false;
    }

    protected void setSelect(ViewSimple v) {
        for (int i = 0; i < this.viewSimple.length; ++i) {
            if (v != this.viewSimple[i]) continue;
            this.setSelect(i);
            this.paintBordure();
            return;
        }
    }

    protected void setSelect(int nview) {
        this.setSelectFromView(false);
        this.unSelectAllView();
        this.viewSimple[nview].selected = true;
    }

    protected void selectAllViews() {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (!this.viewSimple[i].isFree()) {
                this.selectView(i);
            }
            this.viewSimple[i].paintBordure();
        }
    }

    protected void unselectViewsPartial() {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].isFree() || i == this.currentView) continue;
            this.viewSimple[i].selected = false;
            if (this.viewSimple[i].pref != null) {
                this.viewSimple[i].pref.selected = false;
            }
            this.viewSimple[i].paintBordure();
        }
        this.aladin.calque.select.repaint();
    }

    protected void createView4TMOC(Plan p) {
        if (p == null) {
            return;
        }
        this.calque.resumeTimeStackIndex();
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (!this.viewSimple[i].isPlotTime()) continue;
            this.repaintAll();
            return;
        }
        if (!this.getCurrentView().isFree() && !this.isMultiView()) {
            this.setModeView(5);
        }
        int nview = this.aladin.view.getLastNumView(p);
        this.unSelectAllView();
        this.setPlanRef(nview, p);
    }

    protected void setCubeFrame(ViewSimple v, double frameLevel, boolean sync) {
        if (!sync) {
            v.cubeControl.setFrameLevel(frameLevel);
            return;
        }
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].pref != v.pref || !this.viewSimple[i].pref.selected) continue;
            this.viewSimple[i].cubeControl.setFrameLevel(frameLevel);
        }
    }

    protected void resumeStatOnCube() {
        boolean flagMesure = false;
        boolean flagNewView = false;
        for (Obj o : this.vselobj) {
            if (o instanceof SourceStat) {
                ((SourceStat)o).resumeMesures();
                flagMesure = true;
                flagNewView = true;
            }
            if (!(o instanceof Ligne) || ((Ligne)o).bout != 3) continue;
            ((Ligne)o).resumeMesures();
            flagNewView = true;
        }
        if (flagNewView) {
            this.newView(1);
        }
        if (flagMesure) {
            this.aladin.mesure.redisplay();
        }
    }

    protected void syncCube(ViewSimple v) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].pref != v.pref || this.viewSimple[i].cubeControl == v.cubeControl) continue;
            this.viewSimple[i].cubeControl.syncBlink(v.cubeControl);
        }
    }

    public Rainbow showRainbowFilter(ColorModel cm, double min, double max) {
        this.getCurrentView().rainbowF = new Rainbow(this.aladin, cm, min, max);
        return this.getCurrentView().rainbowF;
    }

    public void showRainbow(boolean active) {
        ViewSimple v = this.getCurrentView();
        if (!active && v.rainbow == null) {
            return;
        }
        if (active && v.rainbow == null) {
            v.rainbow = new RainbowPixel(this.aladin, v);
        } else {
            v.rainbow.setVisible(active);
        }
    }

    public boolean hasRainbow() {
        return this.getCurrentView().hasRainbow();
    }

    public boolean rainbowAvailable() {
        return this.getCurrentView().rainbowAvailable();
    }

    protected boolean switchSelectCompatibleViews() {
        if (this.isSelectCompatibleViews()) {
            this.unselectViewsPartial();
            return false;
        }
        this.selectCompatibleViews();
        return true;
    }

    protected void selectCompatibleViews() {
        ViewSimple cv = this.getCurrentView();
        if (!Projection.isOk(cv.pref.projd)) {
            return;
        }
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].isFree() || cv == this.viewSimple[i] || !cv.pref.projd.agree(this.viewSimple[i].pref.projd, this.viewSimple[i])) continue;
            this.selectView(i);
            this.viewSimple[i].paintBordure();
        }
    }

    protected boolean isSelectCompatibleViews() {
        ViewSimple cv = this.getCurrentView();
        if (cv == null || cv.pref == null || !Projection.isOk(cv.pref.projd)) {
            return false;
        }
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].isFree() || cv == this.viewSimple[i] || !cv.pref.projd.agree(this.viewSimple[i].pref.projd, this.viewSimple[i]) || this.viewSimple[i].selected) continue;
            return false;
        }
        return true;
    }

    protected boolean hasCompatibleViews() {
        block4: {
            try {
                ViewSimple cv = this.getCurrentView();
                if (cv == null || cv.pref == null || !Projection.isOk(cv.pref.projd)) {
                    return false;
                }
                int m = this.getNbView();
                for (int i = 0; i < m; ++i) {
                    if (this.viewSimple[i].isFree() || cv == this.viewSimple[i] || cv.pref == this.viewSimple[i].pref && cv.pref.getZ() == this.viewSimple[i].pref.getZ() || this.viewSimple[i].selected || !cv.pref.projd.agree(this.viewSimple[i].pref.projd, this.viewSimple[i])) continue;
                    return true;
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        return false;
    }

    protected int nbSelectedViews() {
        int i = 0;
        int m = this.getNbView();
        for (i = 0; i < m; ++i) {
            if (!this.viewSimple[i].selected) continue;
            ++i;
        }
        return i;
    }

    protected void selectView(int nview) {
        this.setSelectFromView(true);
        this.viewSimple[nview].selected = true;
    }

    protected int getFirstSelectedView() {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (!this.viewSimple[i].selected) continue;
            return i;
        }
        return -1;
    }

    protected ViewSimple getFirstSelectedView(Plan p) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (!this.viewSimple[i].selected || this.viewSimple[i].pref != p) continue;
            return this.viewSimple[i];
        }
        return null;
    }

    protected int selectView(Plan p) {
        int rep = -1;
        for (int i = 0; i < 16; ++i) {
            ViewSimple v = this.viewSimple[i];
            if (v.isFree() || v.pref != p) continue;
            v.selected = true;
            if (rep != -1) continue;
            rep = v.n;
        }
        return rep;
    }

    protected void unSelectAllView() {
        for (int i = 0; i < this.viewSimple.length; ++i) {
            this.viewSimple[i].selected = false;
        }
    }

    protected void recreateMemoryBufferFor(PlanImage pimg) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].pref != pimg) continue;
            this.viewSimple[i].pHashCode = 0;
        }
    }

    protected void resetMegaDrag() {
        this.megaDragViewSource = null;
        this.megaDragPlanSource = null;
        this.flagMegaDrag = false;
    }

    protected boolean isMegaDrag() {
        return this.flagMegaDrag && !this.aladin.isFullScreen();
    }

    protected void startMegaDrag(ViewSimple vSource) {
        if (this.isMegaDrag()) {
            return;
        }
        this.megaDragViewSource = vSource;
        this.flagMegaDrag = true;
    }

    protected void startMegaDrag(Plan pSource) {
        if (this.isMegaDrag()) {
            return;
        }
        this.megaDragPlanSource = pSource;
        this.flagMegaDrag = true;
    }

    private void compute() {
        int perm = 0;
        int on = 0;
        for (int i = 0; i < this.modeView; ++i) {
            int n = this.viewSimple[i].ordreTaquin;
            if (n == -1) {
                n = 15;
            }
            if (i > 1 && on > n) {
                ++perm;
            }
            on = n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean stopMegaDrag(Object target, int x, int y, boolean ctrlPressed) {
        boolean rep;
        block19: {
            rep = true;
            if (!this.isMegaDrag()) {
                return false;
            }
            Aladin.makeCursor(this.aladin.toolBox, 0);
            this.setMyCursor(0);
            int i = this.getTargetViewForEvent(target, x, y);
            ViewSimple viewSimple = this.megaDragViewTarget = i < 0 ? null : this.viewSimple[i];
            if (!this.flagMegaDrag || this.megaDragViewSource == null && this.megaDragPlanSource == null || this.megaDragViewTarget == null) {
                rep = false;
            }
            if (rep && this.megaDragViewTarget == this.megaDragViewSource) {
                rep = false;
            }
            this.flagMegaDrag = false;
            if (rep && !this.megaDragViewTarget.isFree() && (this.megaDragViewTarget.pref instanceof PlanImageBlink || this.megaDragViewTarget.pref.type == 6)) {
                Plan p;
                Plan plan = p = this.megaDragPlanSource != null ? this.megaDragPlanSource : this.megaDragViewSource.pref;
                if (!(p != null && p.isSimpleImage() && Projection.isOk(p.projd) && Projection.isOk(this.megaDragViewTarget.pref.projd))) {
                    rep = false;
                    break block19;
                } else {
                    if (!Aladin.confirmation(Aladin.chaine.getString("ADDFRAMECONF"))) {
                        rep = false;
                    } else if (this.megaDragViewTarget.pref instanceof PlanImageBlink) {
                        ((PlanImageBlink)this.megaDragViewTarget.pref).addPlan((PlanImage)p);
                    } else {
                        ((PlanImageMosaic)this.megaDragViewTarget.pref).addPlan((PlanImage)p);
                    }
                    this.megaDragViewSource = null;
                    this.megaDragPlanSource = null;
                    this.megaDragViewTarget = null;
                    return rep;
                }
            }
            if (rep && (ctrlPressed && this.megaDragViewTarget.isFree() || this.megaDragViewTarget.isPlot()) && this.megaDragPlanSource != null && this.megaDragPlanSource.isSimpleCatalog()) {
                Plan p = this.megaDragPlanSource;
                ViewSimple v = this.megaDragViewTarget;
                if (v.isFree()) {
                    v.setPlanRef(p, false);
                }
                v.addPlotTable(p, -1, -1, true);
            } else if (rep && this.megaDragViewSource != null) {
                boolean copy = ctrlPressed;
                this.aladin.console.printCommand((copy ? "copy " : "mv ") + this.getIDFromNView(this.megaDragViewSource.n) + " " + this.getIDFromNView(this.megaDragViewTarget.n));
                this.moveOrCopyView(this.megaDragViewSource.n, this.megaDragViewTarget.n, copy);
            } else if (rep) {
                if (!this.aladin.calque.canBeRef(this.megaDragPlanSource)) {
                    rep = false;
                }
                if (rep) {
                    this.aladin.console.printCommand("cview " + Tok.quote(this.megaDragPlanSource.label) + " " + this.getIDFromNView(this.megaDragViewTarget.n));
                    this.unSelectAllView();
                    this.setPlanRef(this.megaDragViewTarget.n, this.megaDragPlanSource);
                }
            }
        }
        if (rep) {
            this.unSelectAllView();
            this.megaDragViewTarget.selected = true;
            this.aladin.calque.selectPlan(this.megaDragViewTarget.pref);
            this.setCurrentView(this.megaDragViewTarget);
            this.repaintAll();
            this.aladin.calque.select.repaint();
        }
        this.megaDragViewSource = null;
        this.megaDragPlanSource = null;
        this.megaDragViewTarget = null;
        return rep;
    }

    protected void moveView(int nviewSrc, int nviewTarget) {
        this.moveOrCopyView(nviewSrc, nviewTarget, false);
    }

    protected void copyView(int nviewSrc, int nviewTarget) {
        this.moveOrCopyView(nviewSrc, nviewTarget, true);
    }

    private synchronized void moveOrCopyView(int nviewSrc, int nviewTarget, boolean flagCopy) {
        ViewSimple v = this.viewSimple[nviewTarget];
        ViewControl.moveViewOrder(this.viewSimple, nviewSrc, nviewTarget, flagCopy);
        v.newView(1);
        Properties.majProp(2);
        this.repaintAll();
    }

    protected int getTargetViewForEvent(Object source, int origX, int origY) {
        Dimension vueDim = this.viewSimple[0].getSize();
        int vueInCol = this.aladin.viewControl.getNbCol(this.modeView);
        int x = 0;
        int y = 0;
        if (source instanceof Select) {
            if (origX >= 0) {
                return -1;
            }
            x = this.getSize().width + this.aladin.toolBox.getSize().width + 10 + origX;
            y = origY;
        } else if (source instanceof ViewSimple) {
            int currentView = ((ViewSimple)source).isProjSync() ? ((ViewSimple)source).n : this.getCurrentNumView();
            x = currentView % vueInCol * vueDim.width + origX;
            y = currentView / vueInCol * vueDim.height + origY;
        } else {
            return -1;
        }
        int t = vueInCol * (y / vueDim.height) + x / vueDim.width;
        if (t < 0 || t >= this.getNbView()) {
            t = -1;
        }
        return t;
    }

    protected Position[] getSourceList(Vector v, ViewSimple[] vc, double dist) {
        Position[] b;
        block7: {
            int i;
            Position[] a = new Position[v.size()];
            int n = 0;
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                Obj o = (Obj)e.nextElement();
                if (!o.asSource() && !(o instanceof Repere) && !(o instanceof Tag)) continue;
                Position s = (Position)o;
                boolean flagOut = false;
                for (i = 0; i < vc.length; ++i) {
                    PlanImage p = (PlanImage)vc[i].pref;
                    if (p instanceof PlanBG) continue;
                    int x = (int)s.xv[vc[i].n];
                    int y = (int)s.yv[vc[i].n];
                    if (x > 0 && y > 0 && x <= p.naxis1 && y <= p.naxis2) continue;
                    flagOut = true;
                    break;
                }
                if (flagOut) continue;
                a[n++] = s;
            }
            boolean[] tooClose = new boolean[n];
            Coord o1 = new Coord();
            Coord o2 = new Coord();
            int m = n;
            for (i = 0; i < n; ++i) {
                if (tooClose[i]) continue;
                o1.al = a[i].raj;
                o1.del = a[i].dej;
                for (int j = i + 1; j < n; ++j) {
                    o2.al = a[j].raj;
                    o2.del = a[j].dej;
                    if (!(Coord.getDist(o1, o2) <= dist)) continue;
                    tooClose[j] = true;
                    --m;
                }
            }
            b = new Position[m];
            try {
                int j = 0;
                for (int i2 = 0; i2 < n; ++i2) {
                    if (tooClose[i2]) continue;
                    b[j++] = a[i2];
                }
            }
            catch (Exception e1) {
                if (Aladin.levelTrace < 3) break block7;
                e1.printStackTrace();
            }
        }
        return b;
    }

    protected void createROI() {
        Aladin.makeCursor(this.aladin, 1);
        double radius = this.createROIInternal(0.0, 0, true);
        if (radius > 0.0) {
            this.aladin.console.printCommand("thumbnail " + Coord.getUnit(radius));
        }
    }

    protected void createROI(int taillePixel) {
        this.createROIInternal(0.0, taillePixel, false);
    }

    protected void createROI(double tailleRadius) {
        this.createROIInternal(tailleRadius, 0, false);
    }

    private double createROIInternal(double tailleRadius, int taillePixel, boolean dialog) {
        Position[] src;
        int i;
        int first = -1;
        Vector<ViewSimple> vcVect = new Vector<ViewSimple>();
        int m = this.getNbView();
        for (int i2 = 0; i2 < m; ++i2) {
            ViewSimple vc = this.viewSimple[i2];
            if (vc.isFree() || !vc.pref.flagOk || !vc.pref.isPixel() || !vc.selected || vcVect.contains(vc)) continue;
            vcVect.add(vc);
        }
        if (vcVect.size() == 0) {
            vcVect.add(this.getCurrentView());
        }
        ViewSimple[] vca = new ViewSimple[vcVect.size()];
        Enumeration e = vcVect.elements();
        int i3 = 0;
        while (e.hasMoreElements()) {
            vca[i3] = (ViewSimple)e.nextElement();
            ++i3;
        }
        if (!this.hasSelectedObj()) {
            Plan[] allPlans = this.calque.getPlans();
            for (i = 0; i < allPlans.length; ++i) {
                Plan p = allPlans[i];
                if (!(p instanceof PlanTool) && !p.isCatalog() || !p.flagOk) continue;
                Iterator<Obj> it = p.iterator();
                while (it.hasNext()) {
                    Obj o = it.next();
                    if (!o.asSource() && !(o instanceof Repere)) continue;
                    this.setSelected(o, true);
                }
                if (!this.hasSelectedObj()) continue;
                this.repaintAll();
                this.aladin.mesure.mcanvas.repaint();
                break;
            }
        }
        Vector<Source> vsel = new Vector<Source>();
        for (i = 0; i < this.aladin.mesure.nbSrc; ++i) {
            vsel.add(this.aladin.mesure.src[i]);
        }
        if (tailleRadius == 0.0) {
            ViewSimple vc = vca[0];
            double taille = Math.min(vc.getTailleRA(), vc.getTailleDE());
            if (taille < 1.0) {
                tailleRadius = taille;
            } else {
                Projection proj = vc.getProj();
                if (taillePixel == 0) {
                    taillePixel = vc.pref instanceof PlanBG ? 20 : 40;
                }
                double sizePixel = proj.c.getImgWidth() / (double)proj.c.getImgSize().width;
                tailleRadius = sizePixel * (double)taillePixel;
            }
        }
        if ((src = this.getSourceList(vsel, vca, tailleRadius == 0.0 ? 8.333333333333334E-4 : tailleRadius / 2.0)).length == 0) {
            Aladin.error(ROIWNG);
            return 0.0;
        }
        if (!Aladin.NOGUI && dialog) {
            Aladin.makeCursor(this, 0);
            String pl = vca.length > 1 ? "s" : "";
            StringBuffer stat = new StringBuffer();
            for (int i4 = 0; i4 < vca.length; ++i4) {
                stat.append("\n   .Image: " + vca[i4].pref.label);
            }
            pl = src.length > 1 ? "s" : "";
            stat.append("\n   .Object" + pl + ": " + src.length);
            Panel panel = new Panel();
            TextField radiusROI = new TextField(5);
            radiusROI.setText(Coord.getUnit(tailleRadius));
            panel.add(new Label("Thumbnail size (arcmin):"));
            panel.add(radiusROI);
            if (Message.showFrame(this, ROIINFO + stat, panel, 5) != 1) {
                return 0.0;
            }
            tailleRadius = Server.getRM(radiusROI.getText()) / 60.0;
        }
        if (!this.isMultiView()) {
            this.setModeView(9);
        }
        m = this.getNbView();
        for (int j = 0; j < src.length; ++j) {
            Position o = src[j];
            for (int i5 = 0; i5 < vca.length; ++i5) {
                ViewSimple vc = vca[i5];
                if (vc.isFree() || !vc.pref.flagOk || !vc.pref.isPixel() || !vc.selected) continue;
                int n = this.getNextNumView();
                ViewSimple v = n == -1 ? new ViewSimple(this.aladin, this, this.viewSimple[0].rv.width, this.viewSimple[0].rv.height, 0) : this.viewSimple[n];
                vc.copyIn(v);
                int width = this.isMultiView() ? v.rv.width : v.rv.width / 3;
                v.setCenter(o.raj, o.dej);
                v.setZoomByRadius(tailleRadius, width);
                v.locked = true;
                if (n == -1) {
                    n = this.viewMemo.setAfter(this.previousScrollGetValue + m - 1 - this.getNbStickedView(), v);
                }
                if (first != -1) continue;
                first = n;
            }
        }
        this.aladin.log("createROI", "[" + src.length + " position(s)]");
        this.scrollOn(0);
        this.repaintAll();
        return tailleRadius;
    }

    protected ViewSimple createViewForPlan(Plan p) {
        int n = this.getNextNumView();
        ViewSimple v = n == -1 ? new ViewSimple(this.aladin, this, this.viewSimple[0].rv.width, this.viewSimple[0].rv.height, 0) : this.viewSimple[n];
        v.setPlanRef(p, false);
        p.setActivated(true);
        if (n == -1) {
            this.viewMemo.setAfter(this.previousScrollGetValue + this.getNbView() - 1 - this.getNbStickedView(), v);
        }
        return v;
    }

    protected void setLastClickView(ViewSimple v) {
        this.lastClickView = v;
    }

    protected ViewSimple getLastClickView() {
        return this.lastClickView != null ? this.lastClickView : this.getCurrentView();
    }

    protected synchronized boolean setCurrentView(ViewSimple v) {
        if (this.currentView >= 0 && this.currentView < this.viewSimple.length && this.viewSimple[this.currentView] == v) {
            if (!v.isFree() && this.aladin.dialog != null && !(v.pref instanceof PlanBG)) {
                this.aladin.dialog.setDefaultParameters(this.aladin.dialog.getCurrent(), 4);
            }
            return false;
        }
        this.setLastClickView(null);
        this.currentView = v.n;
        this.setMouseView(v);
        if (!v.isFree()) {
            v.pref.selected = true;
        }
        try {
            if (!v.isFree() && Projection.isOk(v.getProj())) {
                String s1 = Calib.getProjName(v.getProj().c.getProj());
                this.aladin.projSelector.setProjectionSilently(s1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aladin.calque.zoom.reset();
        this.aladin.calque.select.repaint();
        if (v.isFree() || this.aladin.toolBox.tool[0].mode == 0) {
            this.aladin.toolBox.toolMode();
        }
        if (!v.isFree() && !(v.pref instanceof PlanBG)) {
            this.aladin.dialog.setDefaultParameters(this.aladin.dialog.getCurrent(), 4);
        }
        return true;
    }

    protected boolean setCurrentView() {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].isFree() || !this.viewSimple[i].selected) continue;
            this.setCurrentView(this.viewSimple[i]);
            return true;
        }
        return false;
    }

    protected void setDefaultCursor() {
        int tool = this.aladin.toolBox.getTool();
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            this.viewSimple[i].setDefaultCursor(tool, false);
        }
    }

    protected void setDefaultRepere() {
        block3: {
            try {
                ViewSimple v = this.getCurrentView();
                Coord c = v.getCooCentre();
                if (c != null) {
                    this.setRepere(c);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
    }

    protected void adjustViews(Plan p) {
        for (int i = 0; i < this.viewSimple.length; ++i) {
            ViewSimple v = this.viewSimple[i];
            if (v.isFree() || this.aladin.calque.getIndex(v.pref) >= 0) continue;
            v.pref = p;
            v.newView(1);
            v.repaint();
        }
    }

    protected void findBestDefault() {
        if (this.currentView == -1) {
            return;
        }
        if (!this.viewSimple[this.currentView].isFree()) {
            Plan p = this.viewSimple[this.currentView].pref;
            if (this.repere.raj == Double.NaN) {
                try {
                    this.moveRepere(p.projd.c.getImgCenter());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (p.selected) {
                return;
            }
            this.aladin.calque.setPlanRef(p, this.currentView);
            return;
        }
        int i = 0;
        int j = this.currentView + 1;
        while (i < this.viewSimple.length) {
            if (j == this.viewSimple.length) {
                j = 0;
            }
            if (!this.viewSimple[j].isFree()) {
                this.setCurrentView(this.viewSimple[j]);
                return;
            }
            ++i;
            ++j;
        }
        Plan[] allPlans = this.aladin.calque.getPlans();
        j = -1;
        for (i = 0; i < allPlans.length; ++i) {
            Plan p = allPlans[i];
            if (!this.aladin.calque.canBeRef(p)) continue;
            if (!p.isImage() && !(p instanceof PlanBG)) {
                j = i;
                continue;
            }
            this.aladin.calque.setPlanRef(p, this.currentView);
            return;
        }
        if (j != -1) {
            this.aladin.calque.setPlanRef(allPlans[j]);
        }
        this.currentView = 0;
        this.aladin.calque.zoom.zoomView.repaint();
    }

    protected boolean selectViewFromStack(Plan p) {
        this.setSelectFromView(false);
        boolean rep = false;
        int n = 0;
        int j = -1;
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            ViewSimple v = this.viewSimple[i];
            v.selected = false;
            if (v.isFree() || !v.pref.selected) continue;
            rep = true;
            v.selected = true;
            ++n;
            if (j != -1 || v.pref != p) continue;
            j = i;
        }
        if (j != -1) {
            this.setCurrentNumView(j);
            this.aladin.calque.zoom.reset();
            rep = true;
        }
        return rep;
    }

    public void setMouseView(ViewSimple v) {
        if (v == null) {
            this.mouseView = -1;
            this.aladin.calque.selectPlanUnderMouse(null);
            return;
        }
        this.mouseView = v.n;
        v.requestFocusInWindow();
        this.aladin.calque.selectPlanUnderMouse(v.pref);
    }

    protected ViewSimple getMouseView() {
        return this.mouseView == -1 ? null : this.viewSimple[this.mouseView];
    }

    protected int getMouseNumView() {
        return this.mouseView;
    }

    protected int getNbUsedView() {
        this.sauvegarde();
        return this.viewSticked.getNbUsed() + this.viewMemo.getNbUsed();
    }

    protected int getLastUsedView() {
        this.sauvegarde();
        return this.viewMemo.getLastUsed();
    }

    protected boolean hasStickedView() {
        return this.viewSticked.getNbUsed() > 0;
    }

    protected boolean hasLockedView() {
        return true;
    }

    protected int getNbView() {
        try {
            return this.aladin.viewControl.getNbView(this.modeView);
        }
        catch (Exception e) {
            return 1;
        }
    }

    protected int getNbSelectedView() {
        int n = 0;
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i] == null || !this.viewSimple[i].selected) continue;
            ++n;
        }
        return n;
    }

    protected synchronized void setCurrentNumView(int n) {
        this.currentView = n;
        if (this.aladin.dialog != null) {
            this.aladin.dialog.setDefaultParameters(this.aladin.dialog.getCurrent(), 4);
        }
    }

    protected ViewSimple getCurrentView() {
        int m = this.getNbView();
        if (this.currentView >= m) {
            this.setCurrentNumView(m - 1);
        }
        return this.viewSimple[this.currentView];
    }

    protected ViewSimple[] getSelectedView() {
        ViewSimple[] v = new ViewSimple[this.getNbSelectedView()];
        int m = this.getNbView();
        int n = 0;
        for (int i = 0; i < m; ++i) {
            if (!this.viewSimple[i].selected) continue;
            v[n++] = this.viewSimple[i];
        }
        return v;
    }

    protected synchronized int getCurrentNumView() {
        return this.currentView;
    }

    protected int getNextNumView() {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (!this.viewSimple[i].isFree()) continue;
            return i;
        }
        return -1;
    }

    protected int getLastNumView(Plan p) {
        ViewSimple v = this.getCurrentView();
        if (v != null && v.isFree()) {
            return this.getCurrentNumView();
        }
        if (v != null && !v.isFree() && p.isImage() && v.pref.isCatalog() && (!Projection.isOk(p.projd) || p.projd.agree(v.pref.projd, null))) {
            return this.getCurrentNumView();
        }
        int n = this.getNextNumView();
        int nbViews = this.getNbView();
        if (n == -1) {
            for (int i = nbViews - 1; i >= 0; --i) {
                if (this.viewSimple[i].isPlot()) continue;
                n = i;
                break;
            }
        }
        if (n == -1) {
            return nbViews - 1;
        }
        return n;
    }

    public boolean hasFreeView() {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (!this.viewSimple[i].isFree()) continue;
            return true;
        }
        return false;
    }

    protected boolean isMultiView() {
        return this.modeView != 1;
    }

    protected int getModeView() {
        return this.modeView > this.viewSimple.length ? this.viewSimple.length : this.modeView;
    }

    protected StringBuffer getStatus() {
        StringBuffer res = new StringBuffer();
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].isFree()) continue;
            res.append(this.viewSimple[i].getStatus() + "\n");
        }
        return res;
    }

    protected double getPixelValue() {
        int m = this.getNbView();
        if (this.currentView < 0 || this.currentView >= m) {
            return Double.NaN;
        }
        Plan p = this.viewSimple[this.currentView].pref;
        if (p == null) {
            return Double.NaN;
        }
        if (!p.hasAvailablePixels()) {
            return Double.NaN;
        }
        this.repere.projection(this.viewSimple[this.currentView]);
        int x = (int)Math.round(this.repere.xv[this.currentView] - 0.5);
        int y = (int)Math.round(this.repere.yv[this.currentView] - 0.5);
        return ((PlanImage)p).getPixelOriginInDouble(x, ((PlanImage)p).naxis2 - y - 1);
    }

    protected boolean setTimeRange(double[] range) {
        return this.getCurrentView().setTimeRange(range);
    }

    protected void adjustPanel() {
        this.adjustPanel(this.modeView);
    }

    protected void adjustPanel(int m) {
        this.mviewPanel.removeAll();
        int lig = this.aladin.viewControl.getNbLig(m);
        int col = this.aladin.viewControl.getNbCol(m);
        if (this.modeView == 5) {
            GridBagLayout g = new GridBagLayout();
            this.mviewPanel.setLayout(g);
            GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.75, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
            g.setConstraints(this.viewSimple[0], c);
            this.mviewPanel.add(this.viewSimple[0]);
            c.weighty = 0.25;
            c.gridy = 1;
            g.setConstraints(this.viewSimple[1], c);
            this.mviewPanel.add(this.viewSimple[1]);
        } else {
            this.mviewPanel.setLayout(new GridLayout(lig, col, 0, 0));
            if (m == 3) {
                m = 2;
            }
            for (int i = 0; i < m; ++i) {
                this.mviewPanel.add(this.viewSimple[i]);
            }
        }
    }

    protected void setDimension(int w, int h) {
        switch (this.modeView) {
            case 1: {
                this.getCurrentView().setDimension(w, h);
                break;
            }
            default: {
                int lig = this.aladin.viewControl.getNbLig(this.modeView);
                int col = this.aladin.viewControl.getNbCol(this.modeView);
                int m = this.getNbView();
                for (int i = 0; i < m; ++i) {
                    this.viewSimple[i].setDimension(w / col, h / lig);
                }
            }
        }
    }

    void setMyCursor(int type) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            Aladin.makeCursor(this.viewSimple[i], type);
        }
    }

    private void reallocObjetCache() {
        Plan[] allPlans = this.calque.getPlans();
        for (int i = 0; i < allPlans.length; ++i) {
            Plan p = allPlans[i];
            p.reallocObjetCache();
            if (!(p instanceof PlanCatalog)) continue;
            ((PlanCatalog)p).reallocFootprintCache();
        }
        this.newView(1);
    }

    protected Plan getPlanRef(int nview) {
        return this.viewSimple[nview].pref;
    }

    protected void setPlanRef(int nview, Plan p) {
        this.viewSimple[nview].setPlanRef(p, true);
        this.viewMemo.set(this.previousScrollGetValue + nview, this.viewSimple[nview]);
        this.setCurrentView(this.viewSimple[nview]);
    }

    protected void next(int sens) {
        ViewSimple vc = this.getCurrentView();
        Plan p = this.aladin.calque.nextImage(vc.pref, sens);
        if (p == vc.pref) {
            return;
        }
        this.aladin.calque.unSelectAllPlan();
        this.setPlanRef(vc.n, p);
        p.selected = true;
        this.aladin.calque.repaintAll();
    }

    protected boolean isUsed(Plan p) {
        return this.find(p) != -1;
    }

    protected int find(Plan p) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i] == null || this.viewSimple[i].pref != p) continue;
            return i;
        }
        return this.viewMemo.find(p, 0);
    }

    public void autoViewGenerator() {
        int m;
        int n = 0;
        Plan[] allPlans = this.calque.getPlans();
        for (int i = allPlans.length - 1; i >= 0; --i) {
            Plan p = allPlans[i];
            if (!p.isImage() && p.type != 16 || !p.flagOk) continue;
            if (this.isUsed(p)) {
                ++n;
                continue;
            }
            this.createViewForPlan(p);
            ++n;
        }
        System.out.println("n=" + n);
        int n2 = n > 9 ? 16 : (n > 4 ? 9 : (n > 2 ? 4 : (m = n > 1 ? 2 : 1)));
        if (m != this.getModeView()) {
            this.setModeView(m);
        }
        this.aladin.calque.select.repaint();
        this.repaintAll();
    }

    protected void oneView() {
        if (this.currentView != 0) {
            this.moveView(this.currentView, 0);
        }
        for (int i = 1; i < 16; ++i) {
            this.viewSimple[i].free();
        }
        this.sauvegarde();
        this.viewMemo.freeAll();
        this.viewSticked.freeAll();
        this.setModeView(1);
        this.currentView = 0;
        this.scrollOn(0);
        this.repaintAll();
    }

    protected boolean allImageWithView() {
        Plan[] allPlans = this.calque.getPlans();
        for (int i = 0; i < allPlans.length; ++i) {
            Plan p = allPlans[i];
            if (!p.isImage() && p.type != 16 || !p.flagOk || this.isUsed(p)) continue;
            return false;
        }
        return true;
    }

    protected void freeSelected() {
        StringBuffer cmd = new StringBuffer();
        ViewSimple v = this.getLastClickView();
        if (this.aladin.match.isProjSync()) {
            cmd.append(" " + this.getIDFromNView(v.n));
            v.free();
        } else {
            for (int i = 0; i < 16; ++i) {
                if (!this.viewSimple[i].selected) continue;
                cmd.append(" " + this.getIDFromNView(i));
                this.viewSimple[i].free();
            }
            this.viewMemo.freeSelected();
        }
        this.aladin.console.printCommand("rm " + cmd);
        this.sauvegarde();
        int m = this.getNbView();
        if (m == 2 && this.viewSimple[1].isFree() && this.viewMemo.getNbUsed() <= 2) {
            this.setCurrentNumView(0);
            this.oneView();
        }
    }

    protected void free(ViewSimple[] v) {
        StringBuffer cmd = new StringBuffer();
        for (int i = 0; i < v.length; ++i) {
            cmd.append(" " + this.getIDFromNView(i));
            v[i].free();
        }
        this.aladin.console.printCommand("rm " + cmd);
        this.sauvegarde();
    }

    protected boolean hasOnlyPlotView() {
        for (int i = 0; i < 16; ++i) {
            if (this.viewSimple[i].isFree() || this.viewSimple[i].isPlot()) continue;
            return false;
        }
        return true;
    }

    protected boolean hasLock() {
        for (int i = 0; i < 16; ++i) {
            if (!this.viewSimple[i].locked) continue;
            return true;
        }
        this.sauvegarde();
        return this.viewMemo.hasLock();
    }

    protected void freeLock() {
        this.aladin.console.printCommand("rm Lock");
        for (int i = 0; i < 16; ++i) {
            if (!this.viewSimple[i].locked) continue;
            this.viewSimple[i].free();
        }
        this.sauvegarde();
        this.viewMemo.freeLock();
        this.scrollOn(0, 0, 1);
        this.setCurrentNumView(0);
    }

    protected void free(Plan p) {
        for (int i = 0; i < 16; ++i) {
            if (this.viewSimple[i].pref != p) continue;
            this.viewSimple[i].free();
        }
        this.sauvegarde();
        this.viewMemo.freeRef(p);
        this.viewSticked.freeRef(p);
    }

    protected void freeAll() {
        for (int i = 0; i < 16; ++i) {
            this.viewSimple[i].free();
        }
        this.sauvegarde();
        this.viewMemo.freeAll();
        this.viewSticked.freeAll();
        this.scrollOn(0);
    }

    protected boolean isFree() {
        return this.getNbUsedView() == 0;
    }

    protected int getNViewFromID(String vID) {
        int lig;
        int col;
        int n = this.aladin.viewControl.getNbLig(this.modeView);
        try {
            col = "ABCD".indexOf(Character.toUpperCase(vID.charAt(0)));
            lig = Integer.parseInt(vID.substring(1)) - 1;
            if (col < 0 || lig >= n) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return lig * n + col;
    }

    protected String getIDFromNView(int n) {
        int nlig = this.aladin.viewControl.getNbCol(this.modeView);
        char c = (char)(65 + n % nlig);
        return c + "" + (1 + n / nlig);
    }

    protected ViewSimple getView(Plan p) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].pref != p) continue;
            return this.viewSimple[i];
        }
        return null;
    }

    protected boolean isVisibleInSpaceView(Plan p, ViewSimple vc) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].isFree() || this.viewSimple[i].isPlot() || this.viewSimple[i] == vc || !p.projd.agree(this.viewSimple[i].pref.projd, this.viewSimple[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isVisibleInTimeView(Plan p) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].isFree() || !this.viewSimple[i].isPlotTime() || !p.projd.agree(this.viewSimple[i].pref.projd, this.viewSimple[i])) continue;
            return true;
        }
        return false;
    }

    protected int[] getNumView(Plan p) {
        int i;
        int nb = 0;
        int m = this.getNbView();
        nb = 0;
        for (i = 0; i < m; ++i) {
            if (this.viewSimple[i].pref != p) continue;
            ++nb;
        }
        if (nb == 0) {
            return null;
        }
        int[] num = new int[nb];
        nb = 0;
        for (i = 0; i < m; ++i) {
            if (this.viewSimple[i].pref != p) continue;
            num[nb++] = i;
        }
        return num;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public boolean isRecalibrating() {
        return this.aladin.frameNewCalib != null && this.aladin.frameNewCalib.isShowing() && this.aladin.frameNewCalib.getModeCalib() == 1;
    }

    protected boolean syncSimple(Source o) {
        Coord c = new Coord(o.raj, o.dej);
        ViewSimple v = this.aladin.view.getCurrentView();
        if (v.isPlot()) {
            double[] val = v.plot.getValues(o);
            c.al = val[0];
            c.del = val[1];
        }
        boolean rep = true;
        if (!v.isInView(c.al, c.del)) {
            rep = v.setZoomRaDec(0.0, c.al, c.del);
        }
        if (rep) {
            this.repaintAll();
            this.aladin.calque.zoom.newZoom();
            this.aladin.calque.zoom.zoomView.repaint();
        }
        this.moveRepere(c);
        this.showSource(o, false, false);
        this.resetBlinkSource();
        return rep;
    }

    protected void resetBlinkSource() {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            this.viewSimple[i].resetBlinkSource();
        }
    }

    protected boolean syncPlan(Plan p) {
        if (!Projection.isOk(p.projd)) {
            return false;
        }
        Coord c = null;
        if (p instanceof PlanBG) {
            c = p.co;
        } else if (p instanceof PlanField) {
            c = ((PlanField)p).getCenter();
        } else if (p instanceof PlanImage) {
            try {
                c = p.projd.c.getImgCenter();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (c == null) {
            c = p.projd.getProjCenter();
        }
        return this.gotoThere(Projection.isOk(p.projd) ? c : p.co, 0.0, true);
    }

    public boolean gotoThere(Source s) {
        boolean rep = this.gotoThere(new Coord(s.raj, s.dej), 0.0, false);
        this.setRepere(s);
        this.showSource(s, false, false);
        return rep;
    }

    public boolean gotoThere(Coord c) {
        return this.gotoThere(c, 0.0, false);
    }

    public boolean gotoThere(Coord c, double zoom, boolean force) {
        ViewSimple v = this.getCurrentView();
        if (v.locked || c == null) {
            return false;
        }
        if (v.isPlot()) {
            return false;
        }
        this.setRepere(c);
        if (!force && !v.shouldMove(c.al, c.del)) {
            return false;
        }
        if (v.pref instanceof PlanBG) {
            v.getProj().setProjCenter(c.al, c.del);
            v.newView(1);
        }
        double z = zoom <= 0.0 ? v.zoom : this.aladin.calque.zoom.getNearestZoomFct(zoom);
        v.setZoomRaDec(z, c.al, c.del);
        this.showSource();
        this.aladin.calque.zoom.newZoom();
        this.aladin.view.zoomview.repaint();
        return true;
    }

    protected void adjustZoomView(int lastWidth, int width, int lastHeight, int height) {
        ViewSimple v = null;
        for (int i = 0; i < 16; ++i) {
            v = this.viewSimple[i];
            if (v.isFree()) continue;
            v.adjustZoomView(lastWidth, width, lastHeight, height);
        }
    }

    protected void syncTimeRange(ViewSimple vorig) {
        boolean modif = false;
        if (vorig == null) {
            vorig = this.getCurrentView();
        }
        double[] range = vorig.getTimeRange();
        for (int i = 0; i < 16; ++i) {
            ViewSimple v = this.viewSimple[i];
            if (v.locked || v.isFree() || !v.selected || v == vorig || !v.setTimeRange(range, false)) continue;
            v.newView(v.isPlot() ? 0 : 1);
            modif = true;
        }
        if (modif) {
            this.repaintAll();
        }
    }

    protected void syncView(double fct, Coord coo, ViewSimple vOrig) {
        this.syncView(fct, coo, vOrig, false);
    }

    protected void syncView(double fct, Coord coo, ViewSimple vOrig, boolean force) {
        if (vOrig != null && vOrig.isPlot()) {
            return;
        }
        boolean flagNull = coo == null;
        Coord c = flagNull ? new Coord(this.repere.raj, this.repere.dej) : coo;
        for (int i = 0; i < 16; ++i) {
            ViewSimple v = this.viewSimple[i];
            if (v.locked || v.isFree() || v.isPlot() || !force && (v == vOrig && !(v.pref instanceof PlanBG) || !v.shouldMove(c.al, c.del))) continue;
            if (v.pref instanceof PlanBG) {
                v.getProj().setProjCenter(c.al, c.del);
                v.newView(1);
            }
            double z = this.aladin.calque.zoom.getNearestZoomFct(v.zoom * fct);
            v.setZoomRaDec(z, c.al, c.del);
        }
        if (coo == null) {
            this.repaintAll();
        } else {
            this.setRepere(coo);
        }
        this.showSource();
        this.aladin.calque.zoom.newZoom();
        this.aladin.view.zoomview.repaint();
    }

    protected void setPixelInfo(Coord coo) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            ViewSimple v = this.viewSimple[i];
            if (v.isFree() || !v.pref.hasAvailablePixels() || v.isPlot()) continue;
            String s = null;
            Projection proj = v.pref.projd;
            if (Projection.isOk(proj) && coo != null) {
                proj.getXY(coo);
                if (!Double.isNaN(coo.x)) {
                    PointD p = new PointD(coo.x, coo.y);
                    s = v.pref instanceof PlanBG ? ((PlanBG)v.pref).getPixelInfo(p.x, p.y, this.getPixelMode()) : ((PlanImage)v.pref).getPixelInfo((int)Math.floor(p.x), (int)Math.floor(p.y), this.getPixelMode());
                    if (s == PlanImage.UNK) {
                        s = "";
                    }
                }
            }
            v.setPixelInfo(s);
        }
    }

    protected int getPixelMode() {
        return 1;
    }

    protected void flip(PlanImage p, int methode) throws Exception {
        int i;
        Coord[] centre = null;
        if (p.type == 4) {
            throw new Exception("Flip not available for this kind of plane");
        }
        if (Projection.isOk(p.projd)) {
            centre = new Coord[16];
            for (i = 0; i < 16; ++i) {
                centre[i] = null;
                ViewSimple v = this.viewSimple[i];
                if (v.locked || v.pref != p) continue;
                centre[i] = v.getCooCentre();
            }
        }
        p.flip(methode);
        if (centre != null) {
            for (i = 0; i < centre.length; ++i) {
                if (centre[i] == null) continue;
                this.viewSimple[i].setCenter(centre[i].al, centre[i].del);
            }
        }
        this.newView(1);
        this.repaintAll();
    }

    protected void setZoomRaDecForSelectedViews(double z, Coord coo) {
        this.setZoomRaDecForSelectedViews(z, coo, null, true, false);
    }

    protected void setZoomRaDecForSelectedViews(double z, Coord coo, ViewSimple vc, boolean zoomRepaint, boolean flagNow) {
        boolean flagMoveRepere;
        double size = -1.0;
        boolean bl = flagMoveRepere = coo != null;
        if (vc == null) {
            vc = this.getCurrentView();
        }
        Projection proj = vc.pref.projd;
        try {
            size = proj.c.getImgWidth() / (double)proj.c.getImgSize().width;
            if (vc.pref.type == 15) {
                size *= (double)((PlanImageHuge)vc.pref).getStep();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            double nz;
            ViewSimple v = this.viewSimple[i];
            if (vc.isPlotTime() && v != vc) {
                v.newView();
            }
            if (!v.selected && v != vc || v.isPlot() != vc.isPlot()) continue;
            if (size > 0.0 && z != 0.0) {
                try {
                    double cSize = proj.c.getImgWidth() / (double)proj.c.getImgSize().width;
                    if (v.pref.type == 15) {
                        cSize *= (double)((PlanImageHuge)v.pref).getStep();
                    }
                    nz = this.aladin.calque.zoom.getNearestZoomFct(z / (size / cSize));
                }
                catch (Exception e) {
                    nz = z;
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                }
            } else {
                nz = z;
            }
            if (this.isRecalibrating() && this.aladin.toolBox.getTool() == 0 || v.isPlot() || v.locked) {
                v.setZoomXY(nz, v.xzoomView, v.yzoomView);
            } else {
                boolean flag;
                if (coo == null) {
                    coo = new Coord(this.repere.raj, this.repere.dej);
                    if (!flagNow && v.pref instanceof PlanBG) {
                        try {
                            v.getProj().getXY(coo);
                            Coord c1 = v.getCooCentre();
                            v.getProj().getXY(c1);
                            coo.x = c1.x + (coo.x - c1.x) / 3.0;
                            coo.y = c1.y + (coo.y - c1.y) / 3.0;
                            v.getProj().getCoord(coo);
                            PointD p = v.getPositionInView(coo.x, coo.y);
                            if (p.x < 0.0 || p.x > (double)v.rv.width || p.y < 0.0 || p.y > (double)v.rv.height) {
                                coo = new Coord(this.repere.raj, this.repere.dej);
                            }
                        }
                        catch (Exception c1) {
                            // empty catch block
                        }
                    }
                }
                if (v.pref instanceof PlanBG) {
                    Projection pj = v.getProj();
                    pj.setProjCenter(coo.al, coo.del);
                    if (pj != v.pref.projd) {
                        v.pref.projd.setProjCenter(coo.al, coo.del);
                    }
                    v.newView(1);
                }
                if (!(flag = v.setZoomRaDec(nz, coo.al, coo.del)) && nz != v.zoom && v.pref != null) {
                    if (!Projection.isOk(proj) || v.isPlot() || proj.isXYLinear()) {
                        v.setZoomXY(nz, v.xzoomView, v.yzoomView);
                    } else {
                        v.selected = false;
                    }
                }
            }
            v.repaint();
        }
        if (this.crop != null && this.crop.isVisible()) {
            coo = null;
        }
        if (flagMoveRepere) {
            this.moveRepere(coo);
        } else {
            this.repaintAll();
        }
        this.aladin.dialog.adjustParameters();
        if (this.aladin.directory != null) {
            this.aladin.directory.resumeFrameInfo();
        }
        if (zoomRepaint) {
            this.aladin.calque.zoom.newZoom();
            this.aladin.calque.repaintAll();
        }
    }

    public static double[] normalizeRaDec(double ra, double dec) {
        if (ra >= 180.0) {
            ra -= 360.0;
        } else if (ra < -180.0) {
            ra += 360.0;
        }
        return new double[]{ra, dec};
    }

    protected void grilAgain() {
        if (!this.aladin.calque.hasGrid()) {
            return;
        }
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            this.viewSimple[i].oiz = -2L;
        }
    }

    protected void newView() {
        this.newView(1);
    }

    protected void newView(int mode) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            this.viewSimple[i].newView(mode);
        }
    }

    protected boolean hasSelectedObj() {
        return this.vselobj.size() > 0;
    }

    protected Source getFirstSelectedSource() {
        if (this.vselobj == null) {
            return null;
        }
        for (Obj o : this.vselobj) {
            if (!o.asSource()) continue;
            return (Source)o;
        }
        return null;
    }

    protected int nbSelectedObjet() {
        return this.vselobj.size();
    }

    protected boolean hasMocPolSelected() {
        try {
            if (!this.hasSelectedObj()) {
                return false;
            }
            for (Obj o : this.vselobj) {
                if (o instanceof Ligne && ((Ligne)o).isPolygone()) {
                    return true;
                }
                if (o instanceof SourceStat && ((SourceStat)o).hasRayon()) {
                    return true;
                }
                if (o instanceof Cercle) {
                    return true;
                }
                if (o instanceof Box) {
                    return true;
                }
                if (!(o instanceof Ellipse)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean hasOneCoteSelected() {
        int n = 0;
        Enumeration<Obj> e = this.vselobj.elements();
        while (e.hasMoreElements()) {
            Obj o = e.nextElement();
            if (!(o instanceof Cote) || ++n <= 2) continue;
            return false;
        }
        return n == 2;
    }

    protected boolean hasSelectedPhot() {
        Enumeration<Obj> e = this.vselobj.elements();
        while (e.hasMoreElements()) {
            Obj o = e.nextElement();
            if (!o.hasPhot()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSelectedSource() {
        Enumeration<Obj> e = this.vselobj.elements();
        while (e.hasMoreElements()) {
            if (!e.nextElement().asSource()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasMovableObj() {
        return this.hasMovableObj(this.vselobj);
    }

    protected boolean hasMovableObj(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Obj o = (Obj)e.nextElement();
            if (o.asSource() && !(o instanceof SourceTag)) continue;
            return true;
        }
        return false;
    }

    protected Vector<Obj> getSelectedObjet() {
        return this.vselobj;
    }

    protected Source[] getSelectedSources() {
        if (this.vselobj == null) {
            return new Source[0];
        }
        Vector<Source> vSources = new Vector<Source>();
        Enumeration<Obj> eObj = this.vselobj.elements();
        while (eObj.hasMoreElements()) {
            Obj o = eObj.nextElement();
            if (!o.asSource()) continue;
            vSources.addElement((Source)o);
        }
        Object[] sources = new Source[vSources.size()];
        vSources.copyInto(sources);
        vSources = null;
        return sources;
    }

    private Propable getLastPropableObj() {
        Obj rep = null;
        Enumeration<Obj> e = this.vselobj.elements();
        while (e.hasMoreElements()) {
            Obj obj = e.nextElement();
            if (!obj.hasProp()) continue;
            rep = obj;
        }
        return rep;
    }

    protected boolean isPropObjet() {
        return this.selectFromView && this.getLastPropableObj() != null;
    }

    protected void propResume() {
        if (this.aladin.frameProp == null) {
            return;
        }
        this.aladin.frameProp.resume();
    }

    protected void propSelectedObj() {
        Propable obj = this.getLastPropableObj();
        if (obj == null) {
            return;
        }
        this.editPropObj(obj);
    }

    protected void editPropObj(Propable obj) {
        if (obj == null) {
            return;
        }
        if (this.aladin.frameProp == null) {
            this.aladin.frameProp = new FrameProp(this.aladin, "Individual object properties", obj);
        } else {
            this.aladin.frameProp.updateAndShow(obj);
        }
    }

    protected boolean isDelSelObjet() {
        if (!this.selectFromView) {
            return false;
        }
        Enumeration<Obj> e = this.vselobj.elements();
        while (e.hasMoreElements()) {
            Position p = (Position)e.nextElement();
            if (!(p.plan instanceof PlanTool) && !p.plan.isSourceRemovable()) continue;
            return true;
        }
        return false;
    }

    protected void selObjToPad() {
        Enumeration<Obj> e = this.vselobj.elements();
        StringBuffer res = new StringBuffer("\n");
        while (e.hasMoreElements()) {
            Position o = (Position)e.nextElement();
            if (o.asSource() || o.id == null || o.id.length() <= 0) continue;
            res.append(o.id + "\n");
        }
        this.aladin.console.printInPad(res.toString());
    }

    protected void infoCassis(Obj obj) {
        if (Aladin.NOGUI) {
            return;
        }
        if (obj != null) {
            if (!obj.hasPhot() && !(obj instanceof RepereSpectrum)) {
                return;
            }
            Plan p = this.aladin.calque.getPlanBase();
            if (p == null) {
                return;
            }
            if (!p.isCube() && !(p instanceof PlanBG) && ((PlanImage)p).hasOriginalPixels()) {
                return;
            }
        }
        if (!this.aladin.configuration.mustShowHelp(CASSISDEMAND)) {
            return;
        }
        AladinPlugin pg = this.aladin.plugins.find("cassis");
        if (pg != null) {
            return;
        }
        if (Aladin.confirmation(Aladin.chaine.getString(CASSISDEMAND))) {
            FrameVOTool.display(this.aladin, this.aladin.glu.getGluApp("cassis"));
        }
        this.aladin.configuration.showHelpDone(CASSISDEMAND);
    }

    protected void extendClip(Obj o) {
    }

    protected boolean delSelObjet() {
        Enumeration<Obj> e = this.vselobj.elements();
        int tags = 0;
        for (Obj o : this.vselobj) {
            if (!o.asSource() || o.plan == null || !(o.plan instanceof PlanTool)) continue;
            ++tags;
        }
        e = this.vselobj.elements();
        boolean ok = !this.vselobj.isEmpty();
        boolean flagCote = false;
        while (e.hasMoreElements()) {
            Obj o = e.nextElement();
            if (o instanceof Cote) {
                flagCote = true;
            }
            this.extendClip(o);
            if (tags > 1 && o.asSource() && o.plan != null && o.plan instanceof PlanTool) continue;
            if (o.asSource() && ((Source)o).plan.isSourceRemovable()) {
                this.aladin.mesure.remove((Source)o);
            }
            this.calque.delObjet(o);
        }
        this.vselobj.removeAllElements();
        if (flagCote) {
            this.aladin.calque.zoom.zoomView.setCut(null);
        }
        if (tags > 1) {
            Aladin.error(Aladin.chaine.getString("REMOVETAG"));
        }
        if (ok) {
            this.repaintAll();
        }
        return ok;
    }

    protected boolean labelOn() {
        Enumeration<Obj> e = this.vselobj.elements();
        while (e.hasMoreElements()) {
            Obj o = e.nextElement();
            if (!(o instanceof Source) && !(o instanceof Repere) && !(o instanceof Cote) || ((Position)o).isWithLabel()) continue;
            return true;
        }
        return false;
    }

    protected void setSourceLabel() {
        Position o;
        int i;
        boolean enleve = false;
        enleve = true;
        for (i = this.vselobj.size() - 1; i >= 0; --i) {
            o = (Position)this.vselobj.elementAt(i);
            if (!(o instanceof Source) && !(o instanceof Repere) && !(o instanceof Cote)) continue;
            if (!o.isWithLabel()) {
                enleve = false;
            }
            o.setWithLabel(true);
        }
        if (enleve) {
            for (i = this.vselobj.size() - 1; i >= 0; --i) {
                o = (Position)this.vselobj.elementAt(i);
                if (!(o instanceof Source) && !(o instanceof Repere) && !(o instanceof Cote)) continue;
                o.setWithLabel(false);
            }
        }
        this.repaintAll();
    }

    protected boolean deSelect() {
        if (this.vselobj.isEmpty()) {
            return false;
        }
        Enumeration<Obj> e = this.vselobj.elements();
        while (e.hasMoreElements()) {
            Obj o = e.nextElement();
            this.extendClip(o);
            o.setSelect(false);
        }
        this.vselobj.removeAllElements();
        this.aladin.mesure.removeAllElements();
        return true;
    }

    protected void deSelectLigneAndCercle() {
        Vector<Obj> v = new Vector<Obj>(this.vselobj.size());
        for (Obj o : this.vselobj) {
            if (o instanceof Ligne || o instanceof Cercle || o instanceof SourceStat) {
                o.setSelect(false);
                continue;
            }
            v.add(o);
        }
        this.vselobj = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deSelect(Plan p) {
        if (p.isCatalog()) {
            this.aladin.mesure.rmPlanSrc(p);
        }
        if (this.vselobj.isEmpty()) {
            return;
        }
        View view = this;
        synchronized (view) {
            int n = 0;
            int m = this.vselobj.size();
            for (int i = 0; i < m; ++i) {
                Obj o = this.vselobj.elementAt(i);
                if (o instanceof Position && ((Position)o).plan == p) {
                    o.setSelect(false);
                    continue;
                }
                if (i != n) {
                    this.vselobj.setElementAt(o, n);
                }
                ++n;
            }
            if (n == m) {
                return;
            }
            this.vselobj.setSize(n);
        }
        this.resetClip();
        this.repaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTaggedSource(Plan p) {
        if (p.getCounts() == 0) {
            return;
        }
        Iterator<Obj> it = p.iterator();
        boolean trouve = false;
        View view = this;
        synchronized (view) {
            while (it.hasNext()) {
                Obj s = it.next();
                if (!s.asSource() || !((Source)s).isTagged() || ((Source)s).isSelected()) continue;
                ((Source)s).setSelect(true);
                this.vselobj.add(s);
                this.aladin.mesure.insertInfo((Source)s);
                trouve = true;
            }
        }
        if (trouve) {
            this.aladin.mesure.adjustScroll();
            this.aladin.mesure.mcanvas.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Source addSEDSource(Plan p) {
        if (p.getCounts() == 0) {
            return null;
        }
        Vector<Source> v = new Vector<Source>();
        Iterator<Obj> it = p.iterator();
        while (it.hasNext()) {
            Obj s = it.next();
            if (!s.asSource() || !((Source)s).getLeg().isSED()) continue;
            v.add((Source)s);
        }
        if (v.size() == 0) {
            return null;
        }
        View view = this;
        synchronized (view) {
            for (Source s1 : v) {
                s1.setSelect(true);
                this.vselobj.add(s1);
                this.aladin.mesure.insertInfo(s1);
            }
        }
        this.aladin.mesure.adjustScroll();
        this.aladin.mesure.mcanvas.repaint();
        return (Source)v.elementAt(0);
    }

    protected boolean deSelect(Source src) {
        if (this.vselobj.isEmpty()) {
            return false;
        }
        Enumeration<Obj> e = this.vselobj.elements();
        boolean trouve = false;
        int i = 0;
        while (e.hasMoreElements()) {
            Obj o = e.nextElement();
            if (o == src) {
                this.extendClip(o);
                src.setSelect(false);
                this.hideSource();
                trouve = true;
                break;
            }
            ++i;
        }
        if (!trouve) {
            return false;
        }
        this.vselobj.removeElementAt(i);
        this.aladin.mesure.remove(src);
        this.repaintAll();
        return true;
    }

    protected void majSelect() {
        int n = 0;
        int m = this.vselobj.size();
        for (int i = 0; i < m; ++i) {
            Obj o = this.vselobj.elementAt(i);
            if (o.asSource() && !((Source)o).isSelected()) continue;
            if (i != n) {
                this.vselobj.setElementAt(o, n);
            }
            ++n;
        }
        if (n == m) {
            return;
        }
        this.vselobj.setSize(n);
        this.resetClip();
        this.repaintAll();
    }

    protected void resetClip() {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            this.viewSimple[i].resetClip();
        }
    }

    protected void setSelected(Obj o, boolean mode) {
        boolean oMode = o.isSelected();
        if (oMode == mode) {
            return;
        }
        if (!mode) {
            this.vselobj.remove(o);
            if (o.asSource()) {
                this.aladin.mesure.remove((Source)o);
            }
        } else if (!this.vselobj.contains(o)) {
            this.vselobj.addElement(o);
            if (o.asSource()) {
                this.aladin.mesure.insertInfo((Source)o);
            }
        }
        o.setSelect(mode);
    }

    protected void setHighlighted(Source src, boolean flag) {
        if (!flag) {
            this.showSource();
        } else {
            this.showSource(src, false, false);
        }
    }

    protected void selectCote(Obj c1) {
        c1.setSelect(true);
        if (!this.vselobj.contains(c1)) {
            this.vselobj.addElement(c1);
        }
        if (c1 instanceof Cote) {
            Ligne c2 = ((Cote)c1).debligne != null ? ((Cote)c1).debligne : ((Cote)c1).finligne;
            c2.setSelect(true);
            if (!this.vselobj.contains(c2)) {
                this.vselobj.addElement(c2);
            }
        }
    }

    protected void selectSourcesByOID(String[] oid) {
        this.deSelect();
        this.resetClip();
        Source[] o = this.aladin.calque.getSources(oid);
        for (int i = 0; i < o.length; ++i) {
            o[i].setSelect(true);
            if (!o[i].plan.active) {
                o[i].plan.setActivated(true);
            }
            this.vselobj.addElement(o[i]);
            if (i == o.length - 1) {
                this.aladin.mesure.setInfo(o[i]);
                continue;
            }
            this.aladin.mesure.insertInfo(o[i]);
        }
        this.aladin.calque.repaintAll();
        this.aladin.mesure.mcanvas.repaint();
        this.repaint();
    }

    protected void selectSourcesByRowNumber(PlanCatalog pc, int[] rowIdx) {
        this.deSelect();
        this.resetClip();
        Obj[] o = pc.pcat.getObj();
        for (int i = 0; i < rowIdx.length; ++i) {
            Source curObj = (Source)o[rowIdx[i]];
            curObj.setSelect(true);
            if (!curObj.plan.active) {
                curObj.plan.setActivated(true);
            }
            this.vselobj.addElement(curObj);
            if (i == rowIdx.length - 1) {
                this.aladin.mesure.setInfo(curObj);
                continue;
            }
            this.aladin.mesure.insertInfo(curObj);
        }
        this.aladin.calque.repaintAll();
        this.aladin.mesure.mcanvas.repaint();
        this.repaint();
    }

    protected boolean selectAllInPlan(Plan plan) {
        Enumeration<Obj> e = this.vselobj.elements();
        while (e.hasMoreElements()) {
            Position p = (Position)e.nextElement();
            p.setSelect(false);
        }
        this.aladin.mesure.removeAllElements();
        this.vselobj.removeAllElements();
        this.selectAllInPlanWithoutFree(plan, 0);
        this.repaintAll();
        this.aladin.toolBox.toolMode();
        this.aladin.mesure.mcanvas.repaint();
        return true;
    }

    protected void selectAllInPlanWithoutFree(Plan plan, int mode) {
        boolean flagSource = false;
        ViewSimple v = this.getCurrentView();
        if (v.isFree()) {
            v = null;
        }
        Iterator<Obj> it = plan.iterator();
        if (plan.isCatalog() || plan.type == 9) {
            while (it.hasNext()) {
                Obj o1 = it.next();
                if (o1.asSource()) {
                    Source o = (Source)o1;
                    if (mode == 1 && !o.isTagged() || !o.noFilterInfluence() && !o.isSelectedInFilter() || v != null && !o.inTime(v)) continue;
                    this.aladin.mesure.insertInfo(o);
                    flagSource = true;
                } else if (mode == 1) continue;
                o1.setSelect(true);
                this.vselobj.addElement(o1);
            }
            if (flagSource) {
                this.aladin.mesure.adjustScroll();
            }
        }
    }

    protected int getAdvancedSearch(StringBuffer colName, StringBuffer val, String s) {
        int mode = 0;
        int n = s.length();
        int i = s.indexOf(61);
        if (i > 0) {
            if (s.charAt(i - 1) == '!') {
                --i;
                mode = 2;
            } else if (s.charAt(i - 1) == '>') {
                --i;
                mode = 5;
            } else if (s.charAt(i - 1) == '<') {
                --i;
                mode = 6;
            } else {
                mode = i < n - 1 && s.charAt(i + 1) == '=' ? -1 : 1;
            }
        }
        if (mode == 0) {
            i = s.indexOf(62);
        }
        if (mode == 0 && i > 0 && i < n - 1) {
            mode = 3;
        }
        if (mode == 0 && i == -1) {
            i = s.indexOf(60);
        }
        if (mode == 0 && i > 0 && i < n - 1) {
            mode = 4;
        }
        if (mode == 0) {
            val.append(s);
            return 0;
        }
        colName.append(s.substring(0, i).trim());
        n = colName.length();
        if (n > 3 && colName.charAt(0) == '$' && colName.charAt(1) == '{' && colName.charAt(n - 1) == '}') {
            colName.delete(n - 1, n);
            colName.delete(0, 2);
        }
        val.append(Tok.unQuote(s.substring(i + (mode == 1 || mode == 3 || mode == 4 ? 1 : 2))).trim());
        if (mode == -1) {
            mode = 1;
        }
        return mode;
    }

    protected boolean getAbsSearch(StringBuffer colName) {
        if (colName.charAt(0) == '|' && colName.charAt(colName.length() - 1) == '|') {
            colName.deleteCharAt(0);
            colName.deleteCharAt(colName.length() - 1);
            return true;
        }
        return false;
    }

    protected boolean advancedSearch(int mode, boolean numeric, boolean abs, String colVal, String s, double numS) {
        if (mode == 0 || !numeric || s.length() == 0) {
            if (s.length() == 0) {
                return colVal.trim().length() == 0 ? mode != 2 : mode == 2;
            }
            boolean match = s.indexOf(42) < 0 && s.indexOf(63) < 0 ? colVal.indexOf(s) >= 0 : Util.matchMaskIgnoreCase(s, colVal);
            return mode == 1 || mode == 0 ? match : (mode == 2 ? !match : false);
        }
        try {
            double v = Double.parseDouble(colVal);
            if (abs) {
                v = Math.abs(v);
            }
            return mode == 1 ? v == numS : (mode == 2 ? v != numS : (mode == 3 ? v > numS : (mode == 4 ? v < numS : (mode == 5 ? v >= numS : v <= numS))));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void selectSrcByString(String s, int flagAdd) {
        if (flagAdd == 0) {
            this.deSelect();
        }
        StringBuffer col = new StringBuffer();
        StringBuffer v = new StringBuffer();
        int mode = this.getAdvancedSearch(col, v, s);
        s = v.toString();
        boolean abs = false;
        if (col.length() > 0) {
            abs = this.getAbsSearch(col);
        }
        int n = 0;
        if (flagAdd == -1) {
            ArrayList<Integer> list = new ArrayList<Integer>(100);
            Legende oLeg = null;
            int colIndex = -1;
            double numS = Double.MAX_VALUE;
            boolean numeric = false;
            for (int i = 0; i < this.aladin.mesure.nbSrc; ++i) {
                Source o = this.aladin.mesure.src[i];
                if (o.getLeg() != oLeg && col.length() > 0) {
                    oLeg = o.getLeg();
                    colIndex = o.getLeg().matchIgnoreCaseColIndex(col.toString());
                    if (colIndex == -1) break;
                    numeric = o.getLeg().isNumField(colIndex);
                    if (numeric) {
                        try {
                            numS = Double.parseDouble(s);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (!o.noFilterInfluence() && !o.isSelectedInFilter()) continue;
                String[] val = o.getValues();
                boolean trouve = false;
                if (colIndex >= 0) {
                    trouve = this.advancedSearch(mode, numeric, abs, val[colIndex], s, numS);
                } else {
                    for (int k = 0; k < val.length; ++k) {
                        if (Util.indexOfIgnoreCase(val[k], s) < 0) continue;
                        trouve = true;
                        break;
                    }
                }
                if (!trouve) continue;
                ++n;
                o.setSelect(false);
                list.add(new Integer(i));
            }
            if (list.size() > 0) {
                this.aladin.mesure.rmSrc(list);
                this.majSelect();
                this.hideSource();
            }
        } else {
            Plan[] allPlans = this.calque.getPlans();
            block6: for (int j = 0; j < allPlans.length; ++j) {
                Plan p = allPlans[j];
                if (!p.isCatalog() || !p.active) continue;
                int colIndex = -1;
                double numS = Double.MAX_VALUE;
                boolean numeric = false;
                Legende oLeg = null;
                Iterator<Obj> it = p.iterator();
                while (it.hasNext()) {
                    Source o = (Source)it.next();
                    if (oLeg != o.getLeg() && col.length() > 0) {
                        oLeg = o.getLeg();
                        colIndex = o.getLeg().matchIgnoreCaseColIndex(col.toString());
                        if (colIndex == -1) continue block6;
                        numeric = o.getLeg().isNumField(colIndex);
                        if (numeric) {
                            try {
                                numS = Double.parseDouble(s);
                            }
                            catch (Exception k) {
                                // empty catch block
                            }
                        }
                    }
                    if (!o.noFilterInfluence() && !o.isSelectedInFilter()) continue;
                    String[] val = o.getValues();
                    boolean trouve = false;
                    if (colIndex >= 0) {
                        trouve = this.advancedSearch(mode, numeric, abs, val[colIndex], s, numS);
                    } else {
                        for (int k = 0; k < val.length; ++k) {
                            if (Util.indexOfIgnoreCase(val[k], s) < 0) continue;
                            trouve = true;
                            break;
                        }
                    }
                    if (!trouve || o.isSelected()) continue;
                    ++n;
                    o.setSelect(true);
                    this.vselobj.addElement(o);
                    this.aladin.mesure.insertInfo(o);
                }
            }
        }
        Aladin.trace(2, (flagAdd == -1 ? "Search [Sub]:" : (flagAdd == 1 ? "Search [Add]:" : "Search:")) + (col.length() > 0 ? " column \"" + (abs ? "|" : "") + col + (abs ? "|" : "") + "\"" : " string ") + this.OP[mode] + "\"" + s + "\" => " + n + " matched sources");
        if (flagAdd == 1 || n > 0) {
            this.aladin.mesure.adjustScroll();
            this.aladin.mesure.display();
            this.repaintAll();
        }
    }

    protected void selectObjetPlanField(Plan p) {
        Iterator<Obj> it = p.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            this.setSelected(o, true);
        }
    }

    protected void unSelectObjetPlanField(Plan p) {
        if (p.pcat == null) {
            return;
        }
        Iterator<Obj> it = p.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            this.setSelected(o, false);
        }
    }

    protected void unSelect() {
        if (this.deSelect()) {
            this.repaintAll();
            this.aladin.mesure.mcanvas.repaint();
        }
    }

    protected void setMesure() {
        boolean flagExtApp = this.aladin.hasExtApp();
        String[] listOid = null;
        int nbOid = 0;
        boolean plasticFlag = Aladin.PLASTIC_SUPPORT ? this.aladin.getMessagingMgr().isRegistered() : false;
        this.aladin.mesure.removeAllElements();
        Enumeration<Obj> e = this.vselobj.elements();
        if (flagExtApp) {
            listOid = new String[this.vselobj.size()];
        }
        Vector<Source> v = new Vector<Source>();
        while (e.hasMoreElements()) {
            String oid;
            Obj o = e.nextElement();
            if (!o.asSource()) continue;
            if (((Source)o).noFilterInfluence() || ((Source)o).isSelectedInFilter()) {
                o.info(this.aladin);
            } else {
                ((Source)o).setSelect(false);
                v.addElement((Source)o);
            }
            if (!flagExtApp || (oid = ((Source)o).getOID()) == null) continue;
            listOid[nbOid++] = oid;
        }
        Enumeration eObjTodel = v.elements();
        while (eObjTodel.hasMoreElements()) {
            this.vselobj.removeElement(eObjTodel.nextElement());
        }
        this.aladin.toolBox.toolMode();
        this.aladin.mesure.mcanvas.repaint();
        if (flagExtApp) {
            this.aladin.callbackSelectVOApp(listOid, nbOid);
        }
        if (Aladin.PLASTIC_SUPPORT && plasticFlag) {
            try {
                this.aladin.getMessagingMgr().sendSelectObjectsMsg();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.repaintAll();
    }

    private void createRepere() {
        this.repere = new Repere(null);
        this.repere.setType(1);
        this.repere.dej = Double.NaN;
    }

    protected void setRepereId(String s) {
        this.repere.setId("");
    }

    protected boolean setRepere(Source s) {
        Coord coo = new Coord(s.raj, s.dej);
        boolean rep = this.setRepere(coo);
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            ViewSimple v = this.viewSimple[i];
            if (!v.isPlot()) continue;
            rep |= v.setZoomSource(0.0, s);
            this.viewSimple[i].repaint();
        }
        return rep;
    }

    protected boolean setRepere(Coord coo) {
        return this.setRepere(coo, false);
    }

    protected boolean setRepere(Coord coo, boolean force) {
        this.moveRepere(coo);
        this.syncView(1.0, null, null, force);
        boolean rep = false;
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            this.viewSimple[i].repaint();
            rep |= this.viewSimple[i].isInImage(coo.al, coo.del) || this.viewSimple[i].pref instanceof PlanBG;
            if (this.currentView != i || this.viewSimple[i].isFree() || !(this.viewSimple[i].pref instanceof PlanBG) || this.viewSimple[i].projLocal == null) continue;
            this.viewSimple[i].pref.projd.setProjCenter(coo.al, coo.del);
        }
        return rep;
    }

    protected void moveRepere(Coord coo) {
        this.moveRepere(coo.al, coo.del);
    }

    protected void moveRepere(double ra, double dec) {
        this.repere.raj = ra;
        this.repere.dej = dec;
        this.aladin.localisation.setLastCoord(ra, dec);
    }

    protected boolean mustDrawFast() {
        ViewSimple v = this.getCurrentView();
        if (v instanceof ViewSimpleStatic) {
            return false;
        }
        return v.flagScrolling || this.aladin.calque.zoom.zoomView.flagdrag;
    }

    protected void setPaintTimer() {
        this.lastRepaint = Util.getTime();
    }

    protected boolean canDrawAll() {
        if (this.mustDrawFast()) {
            return false;
        }
        long lastDelai = Util.getTime() - this.lastRepaint;
        return lastDelai > 500L;
    }

    protected void sesameResolve(String coord) {
        this.sesameResolve(coord, false);
    }

    protected String sesameResolve(String coord, boolean flagNow) {
        this.saisie = coord;
        this.setRepereId(coord);
        boolean result = true;
        if (coord.trim().length() > 0) {
            if (Localisation.notCoord(coord = this.aladin.localisation.getICRSCoord(coord))) {
                String s = this.miniCache.get(coord);
                if (s != null) {
                    this.saisie = this.aladin.localisation.getFrameCoord(s);
                    Aladin.trace(2, "Sesame: " + coord + " in local cache -> " + this.saisie);
                    result = true;
                } else if (flagNow) {
                    result = new SesameThread(this.saisie, null).resolveSourceName();
                } else {
                    String sesameSyncID = this.sesameSynchro.start("sesame/" + coord, 7000L);
                    SesameThread sesameThread = new SesameThread(this.saisie, sesameSyncID);
                    Util.decreasePriority(Thread.currentThread(), sesameThread);
                    sesameThread.start();
                    return null;
                }
            }
            if (result) {
                this.setRepereByString();
            }
        }
        return result ? this.saisie : null;
    }

    protected boolean sesameResolveForPlan(Plan p) {
        if (oobjet != null && oco != null && p.objet.equals(oobjet)) {
            p.co = oco;
            return true;
        }
        String sesameTaskId = this.sesameSynchro.start("sesameResolveForPlan/" + p);
        SesameThread sesameThread = new SesameThread(p, sesameTaskId);
        Util.decreasePriority(Thread.currentThread(), sesameThread);
        sesameThread.start();
        return false;
    }

    private Coord coordXYLinear(String s) throws Exception {
        if (!this.getCurrentView().pref.projd.isXYLinear()) {
            throw new Exception("No XYlinear conversion available");
        }
        StringBuffer res = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, " :,");
        for (int i = 0; i < 2; ++i) {
            String p = st.nextToken();
            if (p.indexOf(46) < 0) {
                p = p + ".0";
            }
            if (i > 0) {
                res.append(' ');
            }
            res.append(p);
        }
        return new Coord(res.toString());
    }

    private Coord coordXY(String s) throws Exception {
        return this.coordXY1(s, true);
    }

    private Coord coordXYNat(String s) throws Exception {
        return this.coordXY1(s, false);
    }

    private Coord coordXY1(String s, boolean modeFits) throws Exception {
        StringTokenizer st = new StringTokenizer(s, " :,");
        Coord c = new Coord();
        c.x = Double.parseDouble(st.nextToken()) - (modeFits ? 0.5 : 0.0);
        c.y = Double.parseDouble(st.nextToken()) - (modeFits ? 0.5 : 0.0);
        ViewSimple v = this.getCurrentView();
        if (v.pref.isImage() && modeFits) {
            c.y = (double)((PlanImage)v.pref).naxis2 - c.y;
        }
        if (Projection.isOk(v.pref.projd)) {
            v.pref.projd.getCoord(c);
        }
        return c;
    }

    protected boolean setRepereByString() {
        boolean rep;
        block7: {
            rep = false;
            try {
                Coord c = null;
                switch (this.aladin.localisation.getFrame()) {
                    case 12: {
                        c = this.coordXYNat(this.saisie);
                        break;
                    }
                    case 11: {
                        c = this.coordXY(this.saisie);
                        break;
                    }
                    case 13: {
                        c = this.coordXYLinear(this.saisie);
                        break;
                    }
                    default: {
                        c = new Coord(this.aladin.localisation.getICRSCoord(this.saisie));
                    }
                }
                rep = this.setRepere(c, true);
                this.aladin.sendObserver();
            }
            catch (Exception e) {
                Aladin.error("New reticle position error (" + this.saisie + ")", 1);
                if (Aladin.levelTrace < 3) break block7;
                System.err.println(e.getMessage());
            }
        }
        this.nextSaisie = true;
        return rep;
    }

    protected void setRepereByString(String s) {
        block2: {
            try {
                Coord c = new Coord(s);
                this.setRepere(c, true);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block2;
                System.err.println(e.getMessage());
            }
        }
    }

    protected void setRepere(Plan p) {
        if (p.objet == null || p.objet.length() == 0) {
            return;
        }
        if (p.co == null) {
            if (Localisation.notCoord(p.objet)) {
                if (!this.sesameResolveForPlan(p)) {
                    return;
                }
            } else {
                try {
                    p.co = new Coord(p.objet);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
        this.setRepereId(p.objet);
        this.suiteSetRepere(p.co);
    }

    private void suiteSetRepere(Coord c) {
        this.setRepere(c);
        this.calque.setCenterForField(c.al, c.del);
    }

    @Override
    public void run() {
        if (this._flagTimer) {
            this.runC();
        }
    }

    protected void zoomOnSource(Source o) {
        this.getCurrentView().zoomOnSource(o);
    }

    protected Source getShowSource() {
        return this.lastShowSource;
    }

    protected void showSource() {
        if (this.lastShowSource != null) {
            this.showSource(this.lastShowSource, true, false);
        }
    }

    protected void showSource(Source o) {
        this.showSource(o, false, true);
    }

    protected void showSource(Source o, boolean force, boolean callback) {
        if (!force && this.lastShowSource == o) {
            return;
        }
        this.lastShowSource = o;
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            ViewSimple v = this.viewSimple[i];
            if (o != null && o.plan != null && o.plan.pcat != null && !o.plan.pcat.isDrawnInSimpleView(v.getProjSyncView().n)) continue;
            v.changeBlinkSource(o);
        }
        this.blinkMode = 0;
        this.startTimer();
        if (callback && this.aladin.hasExtApp()) {
            String oid = o == null ? null : o.getOID();
            this.aladin.callbackShowVOApp(oid);
        }
        if (callback && Aladin.PLASTIC_SUPPORT) {
            try {
                this.aladin.getMessagingMgr().sendHighlightObjectsMsg(o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void hideSource() {
        this.showSource(null);
    }

    private synchronized void setFlagTimer(boolean a) {
        this._flagTimer = a;
    }

    private synchronized void setDefaultDelais(int d) {
        this.defaultDelais = d;
    }

    synchronized int getDefaultDelais() {
        return this.defaultDelais;
    }

    protected void startTimer() {
        this.startTimer(1000);
    }

    protected void startTimer(int delais) {
        if (Aladin.NOGUI) {
            return;
        }
        this.setDefaultDelais(delais);
        if (this.timer != null) {
            try {
                this.timer.interrupt();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setFlagTimer(true);
        this.timer = new Thread((Runnable)this, "AladinTimer");
        this.timer.setPriority(4);
        this.timer.start();
    }

    protected void stopTimer() {
        this.setFlagTimer(false);
    }

    private boolean isTagEditing() {
        return this.newobj instanceof Tag && ((Tag)this.newobj).isEditing();
    }

    private void runC() {
        long debut = -1L;
        long lastT = -1L;
        int delais = this.getDefaultDelais();
        int tour = 0;
        while (this._flagTimer) {
            try {
                delais = this.getDefaultDelais();
                boolean planBlink = false;
                boolean tagBlink = false;
                boolean editBlink = false;
                boolean sablierBlink = false;
                boolean scrolling = false;
                boolean sourceBlink = false;
                boolean cubeBlink = false;
                int t7 = 0;
                int t6 = 0;
                int t5 = 0;
                int t4 = 0;
                int t3 = 0;
                int t2 = 0;
                int t1 = 0;
                int t0 = 0;
                ViewSimple cv = this.getCurrentView();
                int m = this.getNbView();
                for (int i = 0; i < m; ++i) {
                    ViewSimple v = this.viewSimple[i];
                    boolean planBl = this.calque.hasPlanBlink(v);
                    boolean cube = v.isPlanBlink() && v.cubeControl.mode != CubeControl.PAUSE;
                    boolean source = v.isSourceBlink();
                    boolean scroll = v.isScrolling();
                    boolean sablier = v.isSablier();
                    boolean flagEdit = this.crop != null && this.crop.isEditing() || cv.isPlanBlink() && cv.cubeControl.isEditing();
                    boolean flagtag = this.isTagEditing();
                    if (flagtag && v == cv) {
                        v.repaint();
                        t6 = 500;
                        if (t6 < delais) {
                            delais = t6;
                        }
                    }
                    if (flagEdit && v == cv) {
                        v.repaint();
                        t0 = 500;
                        if (t0 < delais) {
                            delais = t0;
                        }
                    }
                    if (cube && (t1 = v.paintPlanBlink()) < delais) {
                        delais = t1;
                    }
                    if (source) {
                        v.paintSourceBlink();
                        t2 = 150;
                        if (t2 < delais) {
                            delais = t2;
                        }
                    }
                    if (scroll) {
                        v.scrolling();
                        t3 = 25;
                        if (t3 < delais) {
                            delais = t3;
                        }
                    }
                    if (sablier) {
                        v.repaint();
                        t4 = 300;
                        if (t4 < delais) {
                            delais = t4;
                        }
                    }
                    if (planBl) {
                        v.repaint();
                        t7 = 250;
                        if (t7 < delais) {
                            delais = t7;
                        }
                    }
                    tagBlink |= flagtag;
                    editBlink |= flagEdit;
                    cubeBlink |= cube;
                    sourceBlink |= source;
                    scrolling |= scroll;
                    sablierBlink |= sablier;
                    planBlink |= planBl;
                }
                if (t2 > 0) {
                    ++this.blinkMode;
                }
                if (tagBlink | editBlink | cubeBlink | sourceBlink | scrolling | sablierBlink | planBlink) {
                    debut = -1L;
                } else if (debut == -1L) {
                    debut = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - debut > 5000L) {
                    this.stopTimer();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.currentThread();
                Thread.sleep(delais);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++tour;
        }
        this.timer = null;
    }

    protected boolean isPlanBlinkOff() {
        return System.currentTimeMillis() / 250L % 2L == 0L;
    }

    protected boolean isSesameInProgress() {
        return !this.sesameSynchro.isReady();
    }

    protected Coord sesame(String objet) throws Exception {
        URL url = null;
        String s = null;
        if (oobjet != null && oco != null && objet.equals(oobjet)) {
            return oco;
        }
        oco = null;
        boolean flagCache = true;
        boolean isPlanet = this.aladin.configuration.isPlanet();
        try {
            String options = isPlanet ? "SVNI" : "SVN";
            url = this.aladin.glu.getURL("openSesame", "'" + objet + "' " + options, false);
            UrlLoader urlLoader = new UrlLoader(url, this.nbSesameCheck < 2 ? 3000 : 10000);
            String res = urlLoader.getData();
            StringTokenizer st = new StringTokenizer(res, "\n");
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                if (isPlanet && s.startsWith("#=I")) {
                    flagCache = false;
                }
                if (!s.startsWith("%J ")) continue;
                StringTokenizer st1 = new StringTokenizer(s);
                st1.nextToken();
                oco = new Coord(st1.nextToken() + " " + st1.nextToken());
                Aladin.trace(2, "Sesame: " + objet + " -> " + oco.getSexa());
                if (flagCache) {
                    oobjet = objet;
                    this.miniCache.put(objet, oco.getSexa() + " ICRS");
                }
                return oco;
            }
        }
        catch (Exception e) {
            URL url1;
            System.err.println("View.sesame..." + e.getMessage());
            e.printStackTrace();
            if (this.nbSesameCheck < 2 && this.aladin.glu.checkIndirection("openSesame", "") && !url.equals(url1 = this.aladin.glu.getURL("Sesame", URLEncoder.encode(objet), true))) {
                ++this.nbSesameCheck;
                this.aladin.command.console("!!! Automatic Sesame site switch => " + url1);
                return this.sesame(objet);
            }
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            throw new Exception(Aladin.chaine.getString("NOSESAME"));
        }
        return oco;
    }

    protected void stopSED(boolean force) {
        if (!(force || this.zoomview.sed != null && this.zoomview.sed.isLoading())) {
            return;
        }
        this.zoomview.setSED(null);
    }

    protected void startQuickSimbad() {
        this.simRep = null;
        if (this.aladin.view.zoomview.flagSED) {
            this.aladin.view.zoomview.clearSED();
        }
        if (!this.aladin.calque.flagSimbad && !this.aladin.calque.flagVizierSED) {
            return;
        }
        if (this.timerQuickSimbad == null) {
            this.timerQuickSimbad = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    View.this.quickSimbadOnReticle();
                }
            });
            this.timerQuickSimbad.setRepeats(false);
        }
        this.timerQuickSimbad.start();
        this.repaint();
    }

    protected void restartQuickSimbad() {
        if (!this.aladin.calque.flagSimbad && !this.aladin.calque.flagVizierSED) {
            return;
        }
        if (this.simRep != null) {
            return;
        }
        if (this.timerQuickSimbad == null) {
            return;
        }
        this.timerQuickSimbad.restart();
    }

    protected boolean isSimbadOrVizieRPointing() {
        return this.isQuickSimbad || this.isQuickVizieR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quickSimbadOnReticle() {
        try {
            this.isQuickSimbad = true;
            ViewSimple v = this.getMouseView();
            Coord coo = new Coord();
            if (v == null || v.pref == null || v.pref.projd == null || v.lastMove == null) {
                return;
            }
            coo.al = this.repere.raj;
            coo.del = this.repere.dej;
            v.getProj().getXY(coo);
            PointD p1 = v.getViewCoordDble(coo.x, coo.y);
            PointD p2 = v.getViewCoordDble(v.lastMove.x, v.lastMove.y);
            double x2 = p1.x - p2.x;
            double y2 = p1.y - p2.y;
            double d1 = Math.sqrt(x2 * x2 + y2 * y2);
            if (d1 > 10.0) {
                return;
            }
            this.quickSimbad(v, coo, this.calque.flagVizierSED);
        }
        finally {
            this.isQuickSimbad = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quickSimbad(ViewSimple v, Coord coo, boolean flagSED) {
        String s = null;
        String target = coo.getSexa(":");
        double d = coo.del;
        PointD p = v.getViewCoordDble(coo.x, coo.y);
        p = v.getPosition(p.x, p.y - 15.0);
        coo.x = p.x;
        coo.y = p.y;
        v.getProj().getCoord(coo);
        double radius = Util.round(Math.abs(coo.del - d), 7);
        Aladin.makeCursor(v, 13);
        InputStream is = null;
        FilterInputStream cat = null;
        try {
            this.aladin.status.setText("Querying Simbad...");
            URL url = this.aladin.glu.getURL("SimbadQuick", "\"" + target + "\" " + radius, false);
            is = url.openStream();
            if (is != null) {
                cat = new DataInputStream(is);
                s = ((DataInputStream)cat).readLine();
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return;
        }
        finally {
            Aladin.makeCursor(v, 0);
            try {
                if (cat != null) {
                    cat.close();
                } else if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.simRep != null) {
            this.extendClip(this.simRep);
        }
        if (s == null || s.trim().length() == 0) {
            this.simRep = null;
            this.aladin.status.setText("No Simbad object here !");
            if (flagSED) {
                this.quickVizierSED();
            }
        } else {
            StringTokenizer st = new StringTokenizer(s, "/");
            try {
                coo = new Coord(st.nextToken());
                this.simRep = new RepereSimbad(this.aladin, v, coo);
                int i = s.indexOf(47);
                String position = s.substring(0, i).trim();
                String s1 = s.substring(i + 1);
                this.simRep.setId(s1);
                this.aladin.status.setText(s1 + "    [by Simbad]");
                this.aladin.console.printInPad(s1 + "\n");
                String source = s.substring(s.indexOf(47) + 1, s.indexOf(40)).trim();
                this.aladin.targetHistory.add(source);
                this.aladin.view.zoomview.repaint();
                if (flagSED) {
                    Aladin.trace(2, "Loading VizieR phot. for \"" + source + "\" => (" + position + ") ...");
                    this.aladin.view.zoomview.setSED(position, source, this.simRep);
                }
            }
            catch (Exception e) {
                return;
            }
        }
        Aladin.makeCursor(v, 0);
        v.repaint();
    }

    protected void quickVizierSED() {
        try {
            this.isQuickVizieR = true;
            this.quickVizierSED1();
        }
        finally {
            this.isQuickVizieR = false;
        }
    }

    protected void quickVizierSED1() {
        ViewSimple v = this.getMouseView();
        Coord coo = new Coord();
        if (v == null || v.pref == null || v.pref.projd == null) {
            return;
        }
        coo.al = this.repere.raj;
        coo.del = this.repere.dej;
        v.getProj().getXY(coo);
        PointD p1 = v.getViewCoordDble(coo.x, coo.y);
        PointD p2 = v.getViewCoordDble(v.lastMove.x, v.lastMove.y);
        double x2 = p1.x - p2.x;
        double y2 = p1.y - p2.y;
        double d1 = Math.sqrt(x2 * x2 + y2 * y2);
        if (d1 > 10.0) {
            return;
        }
        String target = coo.getSexa();
        Aladin.makeCursor(v, 13);
        try {
            coo = new Coord(target);
            this.simRep = new RepereSimbad(this.aladin, v, coo);
            this.simRep.setId("Phot.: " + target);
            this.aladin.view.zoomview.setSED(target, target, this.simRep);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return;
        }
        Aladin.makeCursor(v, 0);
        v.repaint();
    }

    public void paintBordure() {
        if (this.aladin.menuActivated()) {
            return;
        }
        if (this.aladin.inScriptHelp || this.aladin.inHelp) {
            return;
        }
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            this.viewSimple[i].paintBordure();
        }
    }

    protected boolean isVisible(Plan p) {
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].pref != p) continue;
            return true;
        }
        return false;
    }

    protected boolean tryToShow(Plan p) {
        int debut = this.previousScrollGetValue;
        int m = this.getNbView();
        int fin = debut + m;
        if (this.isVisible(p)) {
            return false;
        }
        int n = this.viewMemo.find(p, fin);
        if (n == -1 || n >= debut && n < fin) {
            int pos = this.viewSticked.find(p, 0);
            if (pos < 0) {
                return false;
            }
            this.setModeView(16);
            p.setActivated(true);
            return true;
        }
        this.scrollOn(n);
        p.setActivated(true);
        return true;
    }

    protected int getNbStickedView() {
        return this.getNbStickedView(-1);
    }

    protected int getNbStickedView(int n) {
        int nbStick = 0;
        if (n == -1) {
            n = 16;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.viewSimple[i].sticked) continue;
            ++nbStick;
        }
        return nbStick;
    }

    public void setModeView(int m) {
        if (this.aladin.viewControl.modeView != m) {
            this.aladin.viewControl.setModeView(m);
        }
        if (this.modeView == m) {
            return;
        }
        int nbView = this.aladin.viewControl.getNbView(m);
        int cNbView = this.aladin.viewControl.getNbView(this.modeView);
        Point pos = null;
        this.sauvegarde();
        pos = this.memoPos != null && this.memoPos.y + this.currentView < nbView ? new Point(this.memoPos.x, this.memoPos.y + this.currentView) : new Point(this.previousScrollGetValue + this.currentView - this.getNbStickedView(this.currentView), 0);
        this.memoPos = nbView < cNbView ? new Point(this.previousScrollGetValue, this.currentView) : null;
        if (m == 1) {
            int x = this.getStickPos(this.currentView);
            this.viewSimple[0].sticked = this.memoStick[x];
            if (this.viewSimple[0].sticked) {
                this.viewSticked.set(0, this.viewSticked.get(x, this.viewSimple[0]));
            }
        }
        this.modeView = m;
        if (m != 1) {
            for (int i = 0; i < nbView; ++i) {
                this.viewSimple[i].sticked = this.memoStick[this.getStickPos(i)];
            }
        }
        int nbStick = 0;
        for (int i = 0; i < nbView; ++i) {
            if (!this.viewSimple[i].sticked) continue;
            ++nbStick;
            this.rechargeFromStick(i);
        }
        int max = pos.x + nbView - nbStick;
        int i = pos.x;
        int j = 0;
        while (i < max) {
            if (!this.viewSimple[j].sticked) {
                this.rechargeFromMemo(i++, j);
            }
            ++j;
        }
        this.previousScrollGetValue = pos.x;
        this.setCurrentNumView(pos.y);
        this.scrollV.setValues(pos.x / nbView, nbView, 0, 1 + this.viewMemo.size() / nbView);
        int bloc = this.aladin.viewControl.getNbLig(m);
        this.scrollV.setBlockIncrement(bloc);
        this.setDimension(this.getSize().width, this.getSize().height);
        this.adjustPanel(m);
        this.reallocObjetCache();
        this.mviewPanel.doLayout();
        this.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
    }

    protected void exportROI(String prefix) {
        this.exportSaveROI(prefix, 0, 0, 0, 0);
    }

    protected void saveROI(String prefix, int w, int h, int fmt) {
        System.out.println("No yet debugged !!!");
    }

    private void exportSaveROI(String prefix, int mode, int w, int h, int fmt) {
        if (prefix == null || prefix.trim().length() == 0) {
            prefix = "ROI";
        }
        ViewSimple v = new ViewSimple(this.aladin, this.aladin.view, 0, 0, 0);
        this.sauvegarde();
        Save save = this.aladin.save != null ? this.aladin.save : new Save(this.aladin);
        Aladin.trace(1, (mode == 0 ? "Exporting locked images in FITS" : "Saving locked views in " + (fmt == 1 ? "BMP" : (fmt == 8 ? "PNG" : "JPEG")) + " " + w + "x" + h) + " files prefixed by [" + prefix + "]");
        int n = this.viewMemo.size();
        int m = 0;
        for (int i = 0; i < n; ++i) {
            if (this.viewMemo.get(i, v) == null || v.isFree() || !v.pref.isPixel()) continue;
            v.rv = new Rectangle(0, 0, this.viewSimple[0].rv.width, this.viewSimple[0].rv.height);
            v.setSize(v.rv.width, v.rv.height);
            v.pref.projd = v.projLocal;
            v.newView(1);
            v.setZoomXY(v.zoom, v.xzoomView, v.yzoomView);
            String name = prefix + Util.align3(++m);
            if (mode == 0) {
                save.saveImage(name + ".fits", v.pref, 0);
                continue;
            }
            save.saveOneView(name + (fmt == 1 ? ".bmp" : (fmt == 8 ? ".png" : ".jpg")), w, h, fmt, -1.0f, v);
        }
        v.free();
        this.newView(1);
        this.repaintAll();
    }

    protected void sauvegarde() {
        if (this.previousScrollGetValue == -1) {
            return;
        }
        int m = this.getNbView();
        int j = this.previousScrollGetValue;
        for (int i = 0; i < m; ++i) {
            if (this.viewSimple[i].sticked) {
                this.viewSticked.set(this.getStickPos(i), this.viewSimple[i]);
                continue;
            }
            this.viewSticked.set(this.getStickPos(i), (ViewSimple)null);
            this.viewMemo.set(j++, this.viewSimple[i]);
        }
    }

    protected void rechargeFromMemo(int i, int j) {
        ViewSimple v = this.viewMemo.get(i, this.viewSimple[j]);
        if (v == null) {
            if (this.viewSimple[j] != null) {
                this.viewSimple[j].free();
            } else {
                this.viewSimple[j] = v;
            }
        }
        if (v == null) {
            return;
        }
        v.n = j;
        if (v.isFree()) {
            return;
        }
        v.setZoomXY(v.zoom, v.xzoomView, v.yzoomView);
        v.newView(1);
    }

    protected void unStickAll() {
        for (int i = 0; i < this.viewSimple.length; ++i) {
            if (!this.viewSimple[i].sticked) continue;
            this.unsetStick(this.viewSimple[i]);
        }
    }

    protected void stickSelectedView() {
        ViewSimple v;
        if (!this.isMultiView()) {
            return;
        }
        StringBuffer sID = new StringBuffer();
        boolean all = true;
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            v = this.viewSimple[i];
            if (!v.selected || v.sticked) continue;
            all = false;
        }
        boolean flag = !all;
        for (int i = 0; i < m; ++i) {
            v = this.viewSimple[i];
            if (!v.selected) continue;
            sID.append(" " + this.getIDFromNView(v.n));
            if (flag) {
                this.setStick(v);
                continue;
            }
            this.unsetStick(v);
        }
        this.aladin.console.printCommand((flag ? "stick" : "unstick") + sID);
        this.repaintAll();
    }

    private void memoStick(int i, boolean flag) {
        int pos = this.getStickPos(i);
        this.memoStick[pos] = flag;
    }

    protected void setStick(ViewSimple v) {
        v.sticked = true;
        this.memoStick(v.n, true);
        this.sauvegarde();
        int m = this.getNbView();
        this.viewMemo.cale(this.previousScrollGetValue + m);
    }

    protected void unsetStick(ViewSimple v) {
        v.sticked = false;
        this.memoStick(v.n, false);
        int m = this.getNbView();
        this.viewMemo.decale(this.previousScrollGetValue + m - 1);
        this.sauvegarde();
    }

    protected int getStickPos(int i) {
        int ligne = this.aladin.viewControl.getNbCol(this.modeView);
        int maxLigne = (int)Math.sqrt(16.0);
        int ajoutParLigne = maxLigne - ligne;
        return i + i / ligne * ajoutParLigne;
    }

    private void rechargeFromStick(int i) {
        this.viewSimple[i] = this.viewSticked.get(this.getStickPos(i), this.viewSimple[i]);
        ViewSimple v = this.viewSimple[i];
        if (v == null) {
            return;
        }
        v.n = i;
        if (v.isFree()) {
            return;
        }
        v.setZoomXY(v.zoom, v.xzoomView, v.yzoomView);
        v.newView(1);
    }

    protected void scrollOn(int n) {
        this.scrollOn(n, 0, 0);
    }

    protected void scrollOn(int n, int current, int mode) {
        int m = this.getNbView();
        this.scrollV.setValue(n / this.aladin.viewControl.getNbCol(this.modeView));
        if (mode != 1) {
            this.sauvegarde();
        }
        int nbStick = 0;
        for (int i = 0; i < m; ++i) {
            if (!this.viewSimple[i].sticked) continue;
            ++nbStick;
            this.rechargeFromStick(i);
        }
        int k = n + m - nbStick;
        int i = n;
        int j = 0;
        while (i < k) {
            if (!this.viewSimple[j].sticked) {
                this.rechargeFromMemo(i++, j);
            }
            ++j;
        }
        this.previousScrollGetValue = n;
        this.setCurrentNumView(current);
        this.memoPos = null;
        this.aladin.calque.majPlanFlag();
        this.aladin.calque.select.repaint();
        for (i = 0; i < m; ++i) {
            this.viewSimple[i].repaint();
        }
    }

    protected int getScrollValue() {
        try {
            return this.scrollV.getValue() * this.aladin.viewControl.getNbCol(this.modeView);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public JPanel getPlotControlPanelForPlan(Plan plan) {
        JPanel p1 = null;
        int n = 0;
        int ct = -1;
        JTabbedPane tab = new JTabbedPane();
        ViewSimple cv = this.aladin.view.getCurrentView();
        int m = this.getNbView();
        for (int i = 0; i < m; ++i) {
            ViewSimple v = this.viewSimple[i];
            if (v.isFree() || !v.isPlot() || (p1 = v.plot.getPlotControlPanelForPlan(plan)) == null) continue;
            tab.add("View " + this.getIDFromNView(i), p1);
            if (v == cv) {
                ct = n;
            }
            ++n;
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return p1;
        }
        JPanel p = new JPanel();
        p.add(tab);
        if (ct >= 0) {
            tab.setSelectedIndex(ct);
        }
        return p;
    }

    protected void activeGrid() {
        if (Aladin.NOGUI) {
            this.opaciteGrid = 1.0f;
            this.repaintAll();
            return;
        }
        this.opaciteGrid = 0.1f;
        new Thread("ActiveGrid"){

            @Override
            public void run() {
                while (View.this.opaciteGrid < 1.0f) {
                    View.this.repaintAll();
                    Util.pause(100);
                    View.this.opaciteGrid += 0.1f;
                }
                View.this.opaciteGrid = 1.0f;
                View.this.repaintAll();
            }
        }.start();
    }

    protected void unactiveGrid() {
        if (Aladin.NOGUI) {
            this.opaciteGrid = 0.0f;
            this.repaintAll();
            return;
        }
        this.opaciteGrid = 0.9f;
        new Thread("UnactiveGrid"){

            @Override
            public void run() {
                while (View.this.opaciteGrid > 0.0f) {
                    View.this.repaintAll();
                    Util.pause(100);
                    View.this.opaciteGrid -= 0.1f;
                }
                View.this.opaciteGrid = 0.0f;
                View.this.aladin.calque.setOverlayFlag("grid", false);
                View.this.repaintAll();
            }
        }.start();
    }

    public void repaintAll() {
        this.propResume();
        this.repaintAll1(0);
    }

    public void updateAll() {
        if (this.aladin.isFullScreen()) {
            this.aladin.fullScreen.repaint();
            return;
        }
        this.repaintAll1(2);
    }

    public void quickRepaintAll() {
        if (this.aladin.isFullScreen()) {
            this.aladin.fullScreen.repaint();
            return;
        }
        this.repaintAll1(1);
    }

    public void repaintAll1(int mode) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaintAllX(mode);
        } else {
            final int Xmode = mode;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    View.this.repaintAllX(Xmode);
                }
            });
        }
    }

    private void repaintAllX(int mode) {
        block14: {
            if (Aladin.NOGUI) {
                mode = 1;
            }
            try {
                boolean hideScroll;
                this.aladin.viewControl.repaint();
                this.aladin.grid.repaint();
                this.aladin.match.repaint();
                this.aladin.look.repaint();
                this.aladin.northup.repaint();
                this.aladin.pix.repaint();
                this.aladin.oeil.repaint();
                this.aladin.csredo.repaint();
                int n = this.getScrollValue();
                int m = this.getNbView();
                boolean bl = hideScroll = this.getLastUsedView() < m && !this.hasStickedView();
                if (this.scrollV.isShowing() && hideScroll) {
                    this.remove(this.scrollV);
                    this.validate();
                } else if (!this.scrollV.isShowing() && !hideScroll) {
                    this.add((Component)this.scrollV, "East");
                    this.validate();
                }
                if (n != this.previousScrollGetValue) {
                    int newCurrent = this.getCurrentNumView() - (n - this.previousScrollGetValue);
                    if (newCurrent < 0) {
                        if (Aladin.levelTrace > 3) {
                            System.err.println("View.repaintAll1(): There is a problem with the scroll value (" + newCurrent + ") => I assume 0 !");
                        }
                        newCurrent = 1;
                    }
                    this.scrollOn(n, newCurrent, 0);
                } else {
                    this.aladin.calque.majPlanFlag();
                    this.aladin.calque.select.repaint();
                    for (int i = 0; i < m; ++i) {
                        if (mode == 2) {
                            this.viewSimple[i].update(this.viewSimple[i].getGraphics());
                            continue;
                        }
                        if (mode == 1) {
                            this.viewSimple[i].paintComponent(this.viewSimple[i].getGraphics());
                            continue;
                        }
                        this.viewSimple[i].resetFlagForRepaint();
                        this.viewSimple[i].repaint();
                    }
                }
                this.aladin.calque.freeUnusedPixelsOrigin();
                this.scrollV.setMaximum(this.viewMemo.size() / this.aladin.viewControl.getNbCol(this.modeView));
                if (this.aladin.frameCM != null && this.aladin.frameCM.isVisible()) {
                    this.aladin.frameCM.majCM();
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block14;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaintAll();
    }

    static {
        oco = null;
        oobjet = null;
    }

    class SesameThread
    extends Thread {
        private Plan planObj;
        private String sourceName;
        private String sesameTaskId;

        SesameThread(String sourceName, String sesameTaskId) {
            super("AladinSesameSourceName");
            this.planObj = null;
            this.sourceName = null;
            this.sourceName = sourceName;
            this.sesameTaskId = sesameTaskId;
        }

        SesameThread(Plan plan, String sesameTaskId) {
            super("AladinSesamePlan");
            this.planObj = null;
            this.sourceName = null;
            this.planObj = plan;
            this.sesameTaskId = sesameTaskId;
        }

        @Override
        public void run() {
            if (this.sourceName != null) {
                this.resolveSourceName();
            } else if (this.planObj != null) {
                this.resolvePlan();
            } else {
                System.err.println("SesameThread error, no plane, no planObj !");
            }
        }

        void resolvePlan() {
            try {
                Coord c = null;
                try {
                    c = View.this.sesame(this.planObj.objet);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                if (c != null) {
                    this.planObj.co = c;
                    View.this.suiteSetRepere(this.planObj.co);
                    View.this.repaintAll();
                }
            }
            finally {
                View.this.sesameSynchro.stop(this.sesameTaskId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean resolveSourceName() {
            try {
                boolean rep = true;
                View.this.aladin.localisation.setTextSaisie(this.sourceName + " ...resolving...");
                Coord c = null;
                try {
                    c = View.this.sesame(this.sourceName);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    System.err.println(e.getMessage());
                }
                if (c == null) {
                    if (this.sourceName.length() > 0) {
                        String s = "Command or object identifier unknown\n \n   " + this.sourceName;
                        View.this.aladin.warning(s);
                    }
                    View.this.aladin.targetHistory.removeLoc(this.sourceName);
                    View.this.saisie = this.sourceName;
                    rep = false;
                } else {
                    View.this.saisie = View.this.aladin.localisation.J2000ToString(c.al, c.del);
                    View.this.aladin.console.printInPad(this.sourceName + " => " + View.this.saisie + " " + View.this.aladin.localisation.getFrameFox() + "\n");
                    if (!View.this.setRepereByString()) {
                        Vector<Plan> v;
                        Aladin cfr_ignored_0 = View.this.aladin;
                        if (!Aladin.NOGUI && (v = View.this.aladin.calque.getPlanBG()) != null && v.size() > 0) {
                            for (Plan p : v) {
                                p.startCheckBoxBlink();
                            }
                            View view = View.this;
                            View.this.aladin.calque.select.setMessageError(view.aladin.getChaine().getString("TARGETNOTVISIBLE"));
                            View.this.aladin.calque.select.repaint();
                        }
                    }
                }
                if (View.this.isFree()) {
                    View.this.aladin.command.setSyncNeedRepaint(false);
                }
                View.this.aladin.localisation.setSesameResult(View.this.saisie);
                boolean bl = rep;
                return bl;
            }
            finally {
                View.this.sesameSynchro.stop(this.sesameTaskId);
            }
        }
    }
}

